/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     SessionFactoryFactoryBean.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.jpa;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.FactoryBean;

import javax.persistence.EntityManagerFactory;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-6-4
 */
public class SessionFactoryFactoryBean implements FactoryBean<SessionFactory> {
    private EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    public SessionFactory getObject() throws Exception {
        return JPAHelper.getSessionFactory(entityManagerFactory);
    }

    @Override
    public Class<?> getObjectType() {
        return SessionFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
