/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntityManagerFactoryBean.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.jpa;

import com.google.common.collect.Sets;
import org.hibernate.cfg.AvailableSettings;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;

import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import java.sql.Connection;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-6-4
 */
public class EntityManagerFactoryBean extends LocalContainerEntityManagerFactoryBean {
    private DatabasePopulator databasePopulator;
    public static final Set<String> AUTOS = Sets.newHashSet("update", "create", "create-drop");

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    @Override
    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
        String hbm2ddlAuto = (String) getJpaPropertyMap().get(AvailableSettings.HBM2DDL_AUTO);
        if (hbm2ddlAuto != null && AUTOS.contains(hbm2ddlAuto) && databasePopulator != null) {
            execute(this.databasePopulator, getDataSource());
        }
        super.postProcessEntityManagerFactory(emf, pui);
    }

    public static void execute(DatabasePopulator populator, DataSource dataSource) {
        Assert.notNull(populator, "DatabasePopulator must be provided");
        Assert.notNull(dataSource, "DataSource must be provided");
        try {
            Connection connection = DataSourceUtils.getConnection(dataSource);
            try {
                populator.populate(connection);
            }
            finally {
                if (connection != null) {
                    connection.commit();
                    DataSourceUtils.releaseConnection(connection, dataSource);
                }
            }
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Failed to execute database script", ex);
        }
    }
}
