/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     UUIDHexGenerator.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-3-26
 */
public class UUIDHexGenerator implements IdentifierGenerator {

    public static final String TYPE = "cn.gtmap.egovplat.core.support.hibernate.UUIDHexGenerator";

    @Override
    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        return UUID.hex32();
    }
}
