/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntityFilterListener.java
 * Modifier: yangxin
 * Modified: 2014-06-18 15:47
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.entity.EntityFilter;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.*;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-18
 */
public class EntityFilterListener implements PostLoadEventListener, SaveOrUpdateEventListener, PersistEventListener, MergeEventListener, PostInsertEventListener, PostUpdateEventListener, PreDeleteEventListener, PostDeleteEventListener, InitializingBean {
    private static final long serialVersionUID = -6594194452243003163L;
    private EntityFilter<Object> filter;
    private SessionFactory sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setFilter(EntityFilter<Object> filter) {
        this.filter = filter;
    }

    @Override
    public void onPostLoad(PostLoadEvent event) {
        filter.prepare(event.getEntity());
    }

    @Override
    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        filter.beforeSave(event.getObject());
    }

    @Override
    public void onPersist(PersistEvent event) throws HibernateException {
        filter.beforeSave(event.getObject());
    }

    @Override
    public void onPersist(PersistEvent event, Map createdAlready) throws HibernateException {
        filter.beforeSave(event.getObject());
    }

    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        filter.beforeSave(event.getEntity());
    }

    @Override
    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        filter.beforeSave(event.getEntity());
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        filter.afterSave(event.getEntity());
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        filter.afterSave(event.getEntity());
    }

    @Override
    public boolean onPreDelete(PreDeleteEvent event) {
        filter.beforeDelete(event.getEntity());
        return false;
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        filter.afterDelete(event.getEntity());
    }

    @Override
    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        EventListenerRegistry registry = ((SessionFactoryImplementor) sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        registry.getEventListenerGroup(EventType.POST_LOAD).appendListener(this);
        registry.getEventListenerGroup(EventType.SAVE).prependListener(this);
        registry.getEventListenerGroup(EventType.UPDATE).prependListener(this);
        registry.getEventListenerGroup(EventType.SAVE_UPDATE).prependListener(this);
        registry.getEventListenerGroup(EventType.PERSIST).prependListener(this);
        registry.getEventListenerGroup(EventType.MERGE).prependListener(this);
        registry.getEventListenerGroup(EventType.POST_INSERT).appendListener(this);
        registry.getEventListenerGroup(EventType.POST_UPDATE).appendListener(this);
        registry.getEventListenerGroup(EventType.PRE_DELETE).appendListener(this);
        registry.getEventListenerGroup(EventType.POST_DELETE).appendListener(this);
    }
}
