/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     CssDirective.java
 * Modifier: yangxin
 * Modified: 2014-06-30 20:06
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.freemarker.directive;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-30
 */
public class CssDirective extends AbstractResourceDirective {
    @Override
    protected String getHtml(String path, String attrs) {
        return "<link href=\"" + path + "\" media=\"all\" rel=\"stylesheet\" type=\"text/css\"/>";
    }

    @Override
    protected String getDefaultBase() {
        return "/static/css";
    }
}