/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     FieldType.java
 * Modifier: yangxin
 * Modified: 2014-06-11 11:05
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.model;

import cn.gtmap.egovplat.core.util.EnumUtils;
import cn.gtmap.egovplat.core.bean.Dictable;
import cn.gtmap.egovplat.core.bean.Titleable;

import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 14-4-22
 */
public enum FieldType implements Titleable, Dictable {
    TEXT("文本"),
    INTEGER("整数"),
    FLOAT("浮点数"),
    DATE("日期"),
    DATETIME("日期时间"),
    BOOLEAN("布尔"),
    FILE("文件"),
    ENUM("枚举"),
    DICT("字典"),
    MODEL("模型");
    private final String title;

    FieldType(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    @Override
    public Map<String, String> getItems() {
        return EnumUtils.getDictMap(FieldType.class);
    }
}
