/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AbstractMessageProvider.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.i18n;

import java.util.Locale;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-26
 */
public abstract class AbstractMessageProvider implements MessageProvider {

    @Override
    public String getMessage(String key) {
        return getMessage(key, null, null, null);
    }

    @Override
    public String getMessage(String key, Object[] args) {
        return getMessage(key, args, null, null);
    }

    @Override
    public String getMessage(String key, Object[] args, String defaultMessage) {
        return getMessage(key, args, defaultMessage, null);
    }

    @Override
    public abstract String getMessage(String key, Object[] args, String defaultMessage, Locale locale);
}
