/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     FreemarkerSourceExtractor.java
 * Modifier: yangxin
 * Modified: 2014-07-02 14:54
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.ex.impl;

import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.ex.Source;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.template.Template;
import freemarker.template.TemplateException;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-2
 */
public class FreemarkerSourceExtractor implements SourceExtractor<TemplateException> {
    private static Method GET_ELEMENT_METHOD;
    private static Method GET_DESCRIPTION_METHOD;
    private static Field LINES_FIELD;

    static {
        try {
            GET_ELEMENT_METHOD = TemplateException.class.getDeclaredMethod("getFailingInstruction");
            GET_ELEMENT_METHOD.setAccessible(true);
            GET_DESCRIPTION_METHOD = TemplateException.class.getDeclaredMethod("getDescription");
            GET_DESCRIPTION_METHOD.setAccessible(true);
            LINES_FIELD = Template.class.getDeclaredField("lines");
            LINES_FIELD.setAccessible(true);
        } catch (Exception e) {
            throw new AppException("Init error", e);
        }
    }

    @Override
    public boolean isSupport(Throwable ex) {
        return ex instanceof TemplateException;
    }

    @Override
    @SuppressWarnings("unchecked")
    public Source extract(TemplateException ex) {
        Environment env = ex.getEnvironment();
        try {
            TemplateElement te = (TemplateElement) GET_ELEMENT_METHOD.invoke(ex);
            if (te != null) {
                Source source = new Source();
                source.setTitle("Freemarker template error");
                source.setDescription((String) GET_DESCRIPTION_METHOD.invoke(ex));
                source.setLineNumber(te.getBeginLine());
                source.setColumNumber(te.getBeginColumn());
                Template template = env.getTemplate();
                source.setLines((List) LINES_FIELD.get(template));
                source.setFile(template.getName());
                return source;
            }
        } catch (Exception ignored) {
        }
        return null;
    }
}
