/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntityExistsException.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.ex;

import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-10
 */
public class EntityExistsException extends EntityException {
    private static final long serialVersionUID = 5977817365829480718L;

    public EntityExistsException(Class clazz, String msg, Throwable cause) {
        super(cause, ENTITY_EXISTS, clazz.getSimpleName(), msg);
    }

    public EntityExistsException(Class clazz, String msg) {
        this(clazz, msg, null);
    }

    public EntityExistsException(Class clazz, String key, Serializable value) {
        this(clazz, key + "=" + value);
    }
}
