/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EnvPrinter.java
 * Modifier: yangxin
 * Modified: 2014-07-02 19:23
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.env;

import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-2
 */
public class EnvPrinter implements ApplicationListener<ContextRefreshedEvent> {
    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (LoggerFactory.getLogger(getClass()).isInfoEnabled()) {
            System.out.println("***************************************************");
            System.out.println("    App mode    : " + Env.mode);
            System.out.println("    App profiles: " + Env.profiles);
            System.out.println("    App ready at: " + Env.getUrl());
            System.out.println("***************************************************");
        }
    }
}
