/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EnvConfigPlaceholderConfigurer.java
 * Modifier: yangxin
 * Modified: 2014-06-11 17:32
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.env;

import cn.gtmap.egovplat.core.attr.Attrs;
import cn.gtmap.egovplat.core.bean.Attrable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.*;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-10
 */
public class EnvConfigPlaceholderConfigurer extends PropertySourcesPlaceholderConfigurer implements Map<String, Object> {
    private MutablePropertySources propertySources;
    private EnvConfigPlaceholderConfigurer parent;

    public void setParent(EnvConfigPlaceholderConfigurer parent) {
        this.parent = parent;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        propertySources = new MutablePropertySources();
        try {
            Properties props = mergeProperties();
            if (parent != null) {
                propertySources.addLast(new PropertySource<Map<String, Object>>("parentProperties", parent) {
                    @Override
                    public String getProperty(String name) {
                        return (String) source.get(name);
                    }
                });
                PropertySource localPropertySource = new PropertiesPropertySource(LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME, props);
                if (this.localOverride) {
                    propertySources.addFirst(localPropertySource);
                } else {
                    propertySources.addLast(localPropertySource);
                }
            } else {
                Env.configuration = Attrs.compositeAttrable(Env.configuration, Attrs.newJSONAttrable(props));
                propertySources.addLast(new PropertySource<Attrable>("envProperties", Env.configuration) {
                    @Override
                    public String getProperty(String name) {
                        return source.getAttr(name);
                    }
                });
                if (this.localOverride) {
                    propertySources.addFirst(new PropertiesPropertySource(LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME, props));
                }
                propertySources.addLast(new SystemEnvironmentPropertySource(StandardEnvironment.SYSTEM_ENVIRONMENT_PROPERTY_SOURCE_NAME, (Map) System.getenv()));
            }
        } catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", ex);
        }
        setPropertySources(propertySources);
        super.postProcessBeanFactory(beanFactory);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(Object key) {
        for (PropertySource<?> propertySource : propertySources) {
            Object candidate = propertySource.getProperty((String) key);
            if (candidate != null) {
                return candidate;
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Entry<String, Object>> entrySet() {
        return null;
    }
}
