/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Env.java
 * Modifier: yangxin
 * Modified: 2014-06-11 14:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.env;

import cn.gtmap.egovplat.core.bean.Attrable;
import cn.gtmap.egovplat.core.util.TypeReference;
import cn.gtmap.egovplat.core.attr.Attrs;
import cn.gtmap.egovplat.core.bean.Titleable;
import cn.gtmap.egovplat.core.util.RequestUtils;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-10
 */
public final class Env {

    public static final String APP_PROFILES = "app.profiles";
    public static final String APP_DOMAIN = "app.domain";
    public static final String APP_SECUREKEY = "app.securekey";
    public static final String APP_URL = "app.url";
    public static final String TASK_ENABLED = "task.enabled";

    static enum Mode implements Titleable {
        DEV("dev"),
        PROD("prod"),
        TEST("test");
        private String title;

        Mode(String title) {
            this.title = title;
        }

        public String getTitle() {
            return title;
        }
    }

    /**
     * 应用模式
     */
    static Mode mode;

    /**
     * 应用profile列表
     */
    static Set<String> profiles;

    /**
     * 是否已启动完成
     */
    static boolean started = false;

    /**
     * 应用配置
     */
    static Attrable configuration = Attrs.newJSONAttrable(System.getProperties());

    public static boolean has(String key) {
        return configuration.hasAttr(key);
    }

    public static String get(String key) {
        return configuration.getAttr(key);
    }

    public static String get(String key, String defaultValue) {
        return configuration.getAttr(key, defaultValue);
    }

    public static String getRequired(String key) throws IllegalStateException {
        return configuration.getRequiredAttr(key);
    }

    public static String getExpr(String text) throws IllegalStateException {
        return configuration.getExprAttr(text);
    }

    public static boolean getBoolean(String key) {
        return configuration.getBoolAttr(key);
    }

    public static boolean isTrue(String key) {
        return getBoolean(key);
    }

    public static boolean isFalse(String key) {
        return !isTrue(key);
    }

    public static byte getByte(String key) {
        return configuration.getByteAttr(key);
    }

    public static short getShort(String key) {
        return configuration.getShortAttr(key);
    }

    public static int getInt(String key) {
        return configuration.getIntAttr(key);
    }

    public static long getLong(String key) {
        return configuration.getLongAttr(key);
    }

    public static float getFloat(String key) {
        return configuration.getFloatAttr(key);
    }

    public static double getDouble(String key) {
        return configuration.getDoubleAttr(key);
    }

    public static byte[] getBytes(String key) {
        return configuration.getBytesAttr(key);
    }

    public static Date getDate(String key) {
        return configuration.getDateAttr(key);
    }

    public static <T> T get(String key, Class<T> targetType) {
        return configuration.getAttr(key, targetType);
    }

    public static <T> T get(String key, Class<T> targetType, T defaultValue) {
        return configuration.getAttr(key, targetType, defaultValue);
    }

    public static <T> T getRequired(String key, Class<T> targetType) throws IllegalStateException {
        return configuration.getRequiredAttr(key, targetType);
    }

    public static <T> T get(String key, TypeReference<T> targetType) {
        return configuration.getAttr(key, targetType);
    }

    public static <T> T get(String key, TypeReference<T> targetType, T defaultValue) {
        return configuration.getAttr(key, targetType, defaultValue);
    }

    public static <T> T getRequired(String key, TypeReference<T> targetType) throws IllegalStateException {
        return configuration.getRequiredAttr(key, targetType);
    }

    public static String[] getArrays(String key) {
        return configuration.getArrayAttr(key);
    }

    public static Map<String, String> gets(Collection<String> keys) {
        return configuration.getAttrs(keys);
    }

    public static Map<String, String> gets(String... keys) {
        return configuration.getAttrs(keys);
    }

    public static Collection<String> getKeys() {
        return configuration.getAttrKeys();
    }

    public static void setAttr(String key, Object value) {
        configuration.setAttr(key, value);
    }

    public static void setAttrIf(String key, Object value) {
        if (!configuration.hasAttr(key)) {
            configuration.setAttr(key, value);
        }
    }

    public static boolean isTaskEnabled() {
        return isTrue(TASK_ENABLED);
    }

    public static boolean hasProfile(String name) {
        return name != null && profiles.contains(name.toLowerCase());
    }

    public static boolean isDev() {
        return mode == Mode.DEV;
    }

    public static boolean isProd() {
        return mode == Mode.PROD;
    }

    public static boolean isTest() {
        return mode == Mode.TEST;
    }

    public static boolean isStarted() {
        return started;
    }

    public static Attrable getConfiguration() {
        return configuration;
    }

    public static Set<String> getProfiles() {
        return profiles;
    }

    public static Mode getMode() {
        return mode;
    }

    public static File getHome() {
        return new File(get(EnvConfLoader.HOME));
    }

    public static String getDomain() {
        return get(APP_DOMAIN);
    }

    public static String getSecureKey() {
        return get(APP_SECUREKEY);
    }

    public static String getUrl() {
        return get(APP_URL);
    }

    public static String getUrl(String relativeUrl) {
        return RequestUtils.formatUrl(getUrl(), relativeUrl);
    }

    private Env() {
    }
}
