/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntitySorter.java
 * Modifier: yangxin
 * Modified: 2014-06-15 16:56
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.entity;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-15
 */
public abstract class EntitySorter<E> {

    public void initWeight(E entity) {
        List<E> siblings = getSiblings(entity);
        if (siblings.isEmpty()) {
            setWeight(entity, 1);
        } else {
            setWeight(entity, getWeight(siblings.get(siblings.size() - 1)) + 1);
        }
    }

    public void move(E entity, boolean isUp) {
        List<E> siblings = getSiblings(entity);
        for (int i = 0; i < siblings.size(); i++) {
            E entity1 = siblings.get(i);
            if (equals(entity1, entity)) {
                if (isUp) {
                    if (i > 0) {
                        swapWeight(entity, siblings.get(i - 1));
                    }
                } else {
                    if (i < siblings.size() - 1) {
                        swapWeight(entity, siblings.get(i + 1));
                    }
                }
                break;
            }
        }
    }

    private void swapWeight(E entity, E entity1) {
        int weight = getWeight(entity);
        setWeight(entity, getWeight(entity1));
        setWeight(entity1, weight);
        save(entity);
        save(entity1);
    }

    protected boolean equals(E entity, E entity1) {
        return entity.equals(entity1);
    }

    protected abstract List<E> getSiblings(E entity);

    protected abstract int getWeight(E entity);

    protected abstract void setWeight(E entity, int weight);

    protected abstract void save(E entity);
}
