/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntityFilterChain.java
 * Modifier: yangxin
 * Modified: 2014-06-13 13:10
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.entity;

import cn.gtmap.egovplat.core.util.ArrayUtils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-13
 */
public class EntityFilterChain<E> implements EntityFilter<E> {
    private LinkedList<EntityFilter<E>> filters = new LinkedList<EntityFilter<E>>();

    public EntityFilterChain(Collection<EntityFilter<E>> filters) {
        setFilters(filters);
    }

    public EntityFilterChain(EntityFilter<E>... filters) {
        this(ArrayUtils.asList(filters));
    }

    public EntityFilterChain() {
    }

    public void setFilters(Collection<EntityFilter<E>> filters) {
        this.filters.addAll(filters);
    }

    public void addFirst(EntityFilter<E> entityFilter) {
        filters.addFirst(entityFilter);
    }

    public void addLast(EntityFilter<E> entityFilter) {
        filters.addLast(entityFilter);
    }

    @Override
    public boolean accept(Class clazz) {
        return true;
    }

    @Override
    public <S extends E> S prepare(S entity) {
        for (EntityFilter<E> ef : filters) {
            if (ef.accept(entity.getClass())) {
                entity = ef.prepare(entity);
            }
        }
        return entity;
    }

    @Override
    public List<E> prepare(List<E> entities) {
        for (EntityFilter<E> ef : filters) {
            if (entities.size() > 0) {
                if (!ef.accept(entities.get(0).getClass())) {
                    continue;
                }
            }
            entities = ef.prepare(entities);
        }
        return entities;
    }

    @Override
    public E beforeSave(E entity) {
        for (EntityFilter<E> ef : filters) {
            if (ef.accept(entity.getClass())) {
                entity = ef.beforeSave(entity);
            }
        }
        return entity;
    }

    @Override
    public E afterSave(E entity) {
        for (EntityFilter<E> ef : filters) {
            if (ef.accept(entity.getClass())) {
                entity = ef.afterSave(entity);
            }
        }
        return entity;
    }

    @Override
    public E beforeDelete(E entity) {
        for (EntityFilter<E> ef : filters) {
            if (ef.accept(entity.getClass())) {
                entity = ef.beforeDelete(entity);
            }
        }
        return entity;
    }

    @Override
    public E afterDelete(E entity) {
        for (EntityFilter<E> ef : filters) {
            if (ef.accept(entity.getClass())) {
                entity = ef.afterDelete(entity);
            }
        }
        return entity;
    }
}
