/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     EntityFilter.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

/**
 *
 */
package cn.gtmap.egovplat.core.entity;

import java.util.List;

/**
 * @param <E>
 * @author Alex.Sun
 */
public interface EntityFilter<E> {

    boolean accept(Class<?> clazz);

    public abstract <S extends E> S prepare(S entity);

    public abstract List<E> prepare(List<E> entities);

    public abstract E beforeSave(E entity);

    public abstract E afterSave(E entity);

    public abstract E beforeDelete(E entity);

    public abstract E afterDelete(E entity);
}