/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     BaseEntityFilter.java
 * Modifier: yangxin
 * Modified: 2014-06-13 14:30
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.entity;

import cn.gtmap.egovplat.core.util.DateUtils;

import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-13
 */
public class BaseEntityFilter<E extends BaseEntity> implements EntityFilter<E> {

    @Override
    public boolean accept(Class<?> clazz) {
        return BaseEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public <S extends E> S prepare(S entity) {
        return entity;
    }

    @Override
    public List<E> prepare(List<E> entities) {
        return entities;
    }

    @Override
    public E beforeSave(E entity) {
        if (entity.isNew()) {
            entity.setId(null);
            Date now = DateUtils.now();
            entity.setCreateAt(now);
            entity.setUpdateAt(now);
        }
        return entity;
    }

    @Override
    public E afterSave(E entity) {
        return entity;
    }

    @Override
    public E beforeDelete(E entity) {
        entity.setUpdateAt(new Date());
        return entity;
    }

    @Override
    public E afterDelete(E entity) {
        return entity;
    }
}
