/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AbstractEntityFilter.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.entity;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-11-7
 */
public abstract class AbstractEntityFilter<E> implements EntityFilter<E> {

    @Override
    public <S extends E> S prepare(S entity) {
        return entity;
    }

    @Override
    public List<E> prepare(List<E> entities) {
        for (int i = 0, len = entities.size(); i < len; i++) {
            E be = entities.get(i);
            E ae = prepare(be);
            if (ae != be) {
                entities.set(i, ae);
            }
        }
        return entities;
    }

    @Override
    public E beforeSave(E entity) {
        return entity;
    }

    @Override
    public E afterSave(E entity) {
        return entity;
    }

    @Override
    public E beforeDelete(E entity) {
        return entity;
    }

    @Override
    public E afterDelete(E entity) {
        return entity;
    }
}
