/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Criterion.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data.dsl;

import com.google.common.collect.Range;

import java.util.Collection;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-7-2
 */
@SuppressWarnings("rawtypes")
public interface Criterion<T extends Criterion> {

    T and(Criterion... criterions);

    T and(Collection<Criterion> criterions);

    T or(Criterion... criterions);

    T or(Collection<Criterion> criterions);

    T expr(String expr);

    T expr(String... exprs);

    T expr(Collection<String> exprs);

    T isNull(String name);

    T notNull(String name);

    T empty(String name);

    T notEmpty(String name);

    T eq(String name, Object value);

    T eqIf(String name, Object value, boolean... conditions);

    T eqIfHasValue(String name, Object value);

    T eqOrNull(String name, Object value);

    T ne(String name, Object value);

    T neIf(String name, Object value);

    T neOrNotNull(String name, Object value);

    T like(String name, String value);

    T likeIf(String name, String value);

    T like(String name, String value, MatchMode matchMode);

    T likeIf(String name, String value, MatchMode matchMode);

    T gt(String name, Object value);

    T gtIf(String name, Object value);

    T lt(String name, Object value);

    T ltIf(String name, Object value);

    T ge(String name, Object value);

    T geIf(String name, Object value);

    T le(String name, Object value);

    T leIf(String name, Object value);

    T between(String name, Object lo, Object hi);

    T between(String name, Range range);

    T in(String name, Object value);

    T in(String name, Object... values);

    T in(String name, Collection values);

    T notIn(String name, Object value);

    T notIn(String name, Object... values);

    T notIn(String name, Collection values);

    T exists(Object value);

    T notExists(Object value);
}
