/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Pageable.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data;

import com.mysema.query.types.OrderSpecifier;

import java.util.Collection;

/**
 * 如果size属性为ALL,返回所有记录 如果size属性为NONE,只返回总数 如果size小于0,忽略获取总数
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-7-12
 */
public interface Pageable {

    int SIZE_ALL = Integer.MAX_VALUE;
    int SIZE_NONE = 0;
    int SIZE_DEFAULT = 20;

    int OFFSET_FIRST = 0;
    int INDEX_FIRST = 1;

    int getSize();

    int getOffset();

    int getIndex();

    Collection<Order> getOrders();

    Pageable next();

    Pageable previous();

    Pageable order(Order order);

    Pageable order(OrderSpecifier order);
}
