/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Page.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data;

import java.util.List;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-7-12
 */
public interface Page<T> extends Pageable, Iterable<T> {

    long getTotalCount();

    int getPageCount();

    int getItemSize();

    List<T> getItems();

    T getItem(int index);

    T getFirst();

    T getLast();

    boolean isEmpty();

    boolean isNotEmpty();

    boolean hasPrevious();

    boolean hasNext();

    boolean isFirst();

    boolean isLast();

    List<Integer> getShowIndexs();
}
