/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     P.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.data;


import cn.gtmap.egovplat.core.util.ArrayUtils;
import com.mysema.query.types.OrderSpecifier;

import java.util.Collection;
import java.util.Collections;

import static cn.gtmap.egovplat.core.data.PageRequest.toOffset;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-11-5
 */
public final class P {

    public static final Pageable DEFAULT = P.first();

    public static Pageable offset(int offset, int size, Collection<Order> orders) {
        return new PageRequest(offset, size, orders);
    }

    public static Pageable offset(int offset, int size, Order... orders) {
        return offset(offset, size, ArrayUtils.asList(orders));
    }

    public static Pageable offset(int offset, int size, boolean asc, String... fields) {
        return offset(offset, size, Order.orders(asc, fields));
    }

    public static Pageable offset(int offset, int size, String... fields) {
        return offset(offset, size, Order.orders(fields));
    }

    public static Pageable offset(int offset, int size) {
        return offset(offset, size, Collections.<Order>emptyList());
    }

    public static Pageable offset(int offset, Order... orders) {
        return offset(offset, Pageable.SIZE_DEFAULT, orders);
    }

    public static Pageable offset(int offset) {
        return offset(offset, Pageable.SIZE_DEFAULT);
    }

    public static Pageable index(int index, int size, Collection<Order> orders) {
        return offset(toOffset(index, size), size, orders);
    }

    public static Pageable index(int index, int size, Order... orders) {
        return offset(toOffset(index, size), size, orders);
    }

    public static Pageable index(int index, int size, boolean asc, String... fields) {
        return offset(toOffset(index, size), size, asc, fields);
    }

    public static Pageable index(int index, int size, String... fields) {
        return offset(toOffset(index, size), size, fields);
    }

    public static Pageable index(int index, int size) {
        return offset(toOffset(index, size), size);
    }

    public static Pageable index(int index, Order... orders) {
        return offset(toOffset(index, Pageable.SIZE_DEFAULT), orders);
    }

    public static Pageable index(int index) {
        return offset(toOffset(index, Pageable.SIZE_DEFAULT));
    }

    public static Pageable first(int size, Collection<Order> orders) {
        return offset(Pageable.OFFSET_FIRST, size, orders);
    }

    public static Pageable first(int size, Order... orders) {
        return offset(Pageable.OFFSET_FIRST, size, orders);
    }

    public static Pageable first(int size, boolean asc, String... fields) {
        return offset(Pageable.OFFSET_FIRST, size, asc, fields);
    }

    public static Pageable first(int size, String... fields) {
        return offset(Pageable.OFFSET_FIRST, size, fields);
    }

    public static Pageable first(Order... orders) {
        return offset(Pageable.OFFSET_FIRST, orders);
    }

    public static Pageable first(int size) {
        return offset(Pageable.OFFSET_FIRST, size);
    }

    public static Pageable first() {
        return offset(Pageable.OFFSET_FIRST, Pageable.SIZE_DEFAULT);
    }

    public static Pageable all() {
        return offset(Pageable.OFFSET_FIRST, Pageable.SIZE_ALL);
    }

    public static Pageable none() {
        return offset(Pageable.OFFSET_FIRST, Pageable.SIZE_NONE);
    }

    public static Pageable offset(int offset, int size, OrderSpecifier... orders) {
        return offset(offset, size, Order.orders(orders));
    }

    public static Pageable offset(int offset, OrderSpecifier... orders) {
        return offset(offset, Pageable.SIZE_DEFAULT, orders);
    }

    public static Pageable index(int index, int size, OrderSpecifier... orders) {
        return offset(toOffset(index, size), size, orders);
    }

    public static Pageable index(int index, OrderSpecifier... orders) {
        return offset(toOffset(index, Pageable.SIZE_DEFAULT), orders);
    }

    public static Pageable first(int size, OrderSpecifier... orders) {
        return offset(Pageable.OFFSET_FIRST, size, orders);
    }

    public static Pageable first(OrderSpecifier... orders) {
        return offset(Pageable.OFFSET_FIRST, orders);
    }

    private P() {
    }
}
