/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Attrable.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.bean;

import cn.gtmap.egovplat.core.util.TypeReference;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-2-28
 */
public interface Attrable {

    boolean isAttrsEmpty();

    boolean hasAttr(String key);

    String getAttr(String key);

    String getAttr(String key, String defaultValue);

    String getRequiredAttr(String key) throws IllegalStateException;

    String getExprAttr(String text) throws IllegalStateException;

    boolean getBoolAttr(String key);

    byte getByteAttr(String key);

    short getShortAttr(String key);

    int getIntAttr(String key);

    long getLongAttr(String key);

    float getFloatAttr(String key);

    double getDoubleAttr(String key);

    byte[] getBytesAttr(String key);

    Date getDateAttr(String key);

    <T> T getAttr(String key, Class<T> targetType);

    <T> T getAttr(String key, Class<T> targetType, T defaultValue);

    <T> T getRequiredAttr(String key, Class<T> targetType) throws IllegalStateException;

    <T> T getAttr(String key, TypeReference<T> targetType);

    <T> T getAttr(String key, TypeReference<T> targetType, T defaultValue);

    <T> T getRequiredAttr(String key, TypeReference<T> targetType) throws IllegalStateException;

    String[] getArrayAttr(String key);

    Collection<String> getAttrKeys();

    Map<String, String> getAttrs();

    Map<String, String> getAttrs(String... keys);

    Map<String, String> getAttrs(Collection<String> keys);

    void setAttr(String key, Object value);

    void setAttrs(Map<String, ?> map);

    void removeAttr(String key);

    void removeAttrs(String... keys);

    void removeAttrs(Collection<String> keys);

    void clearAttrs();
}
