/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AttrableMap.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.attr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-31
 */
public class MapAttrable extends AbstractJSONAttrable implements Map<String, String>, Serializable {
    private static final long serialVersionUID = -2215595339918305246L;
    private Map<String, String> map;

    public MapAttrable(Map<String, String> map) {
        this.map = map;
    }

    @SuppressWarnings("unchecked")
    public MapAttrable(Properties properties) {
        this.map = (Map) properties;
    }

    public MapAttrable() {
        this.map = Maps.newLinkedHashMap();
    }

    public Map<String, String> getMap() {
        return map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    @Override
    protected String getStringAttribute(String key) {
        return map.get(key);
    }

    @Override
    protected void setStringAttribute(String key, String value) {
        map.put(key, value);
    }

    @Override
    @JSONField(serialize = false)
    public boolean isAttrsEmpty() {
        return isEmpty();
    }

    @Override
    public boolean hasAttr(String key) {
        return containsKey(key);
    }

    @Override
    public String getAttr(String key) {
        return map.get(key);
    }

    @Override
    @JSONField(serialize = false)
    public Collection<String> getAttrKeys() {
        return map.keySet();
    }

    @Override
    @JSONField(serialize = false)
    public Map<String, String> getAttrs() {
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map<String, String> getAttrs(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return getAttrs();
        }
        return super.getAttrs(keys);
    }

    @Override
    public void removeAttr(String key) {
        map.remove(key);
    }

    @Override
    public int size() {
        return map.size();
    }

    @Override
    public boolean isEmpty() {
        return map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return map.get(key);
    }

    @Override
    public String put(String key, String value) {
        return map.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        map.putAll(m);
    }

    @Override
    public void clear() {
        map.clear();
    }

    @Override
    public Set<String> keySet() {
        return map.keySet();
    }

    @Override
    public Collection<String> values() {
        return map.values();
    }

    @Override
    public Set<Entry<String, String>> entrySet() {
        return map.entrySet();
    }

    @Override
    public String toString() {
        return JSON.toJSONString(map);
    }
}
