/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     CompositeAttrableEx.java
 * Modifier: yangxin
 * Modified: 2014-06-12 21:05
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.attr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cn.gtmap.egovplat.core.bean.Attrable;
import cn.gtmap.egovplat.core.util.ArrayUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-31
 */
public class CompositeAttrableEx extends AbstractAttrable implements Serializable {
    private static final long serialVersionUID = 6817948390932263126L;
    private final Attrable attr;
    private final List<Attrable> parents;

    public CompositeAttrableEx(Attrable attr, Attrable... parents) {
        this.attr = attr;
        this.parents = ArrayUtils.asList(parents);
    }

    public CompositeAttrableEx(Attrable attr, Collection<Attrable> parents) {
        this.attr = attr;
        this.parents = Lists.newArrayList(parents);
    }

    public Attrable getAttr() {
        return attr;
    }

    @Override
    public boolean isAttrsEmpty() {
        if (!attr.isAttrsEmpty()) {
            return false;
        }
        for (Attrable p : parents) {
            if (!p.isAttrsEmpty()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasAttr(String key) {
        if (attr.hasAttr(key)) {
            return true;
        }
        for (Attrable p : parents) {
            if (p.hasAttr(key)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAttr(String key) {
        if (attr.hasAttr(key)) {
            return attr.getAttr(key);
        }
        for (Attrable p : parents) {
            if (p.hasAttr(key)) {
                return p.getAttr(key);
            }
        }
        return null;
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        if (attr.hasAttr(key)) {
            return attr.getAttr(key, targetType);
        }
        for (Attrable p : parents) {
            if (p.hasAttr(key)) {
                return p.getAttr(key, targetType);
            }
        }
        return null;
    }

    @Override
    public Collection<String> getAttrKeys() {
        Set<String> keys = Sets.newLinkedHashSet(attr.getAttrKeys());
        for (Attrable p : parents) {
            keys.addAll(p.getAttrKeys());
        }
        return keys;
    }

    @Override
    public void setAttr(String key, Object value) {
        attr.setAttr(key, value);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        attr.setAttrs(map);
    }

    @Override
    public void removeAttr(String key) {
        attr.removeAttr(key);
    }

    @Override
    public String toString() {
        return attr.toString();
    }
}
