/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AbstractJSONAttrable.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.attr;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-31
 */
public abstract class AbstractJSONAttrable extends AbstractAttrable {

    @Override
    public String getAttr(String key) {
        return getStringAttribute(key);
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        return convert(getStringAttribute(key), targetType);
    }

    @Override
    public void setAttr(String key, Object value) {
        setStringAttribute(key, convert(value, String.class));
    }

    protected <T> T convert(Object value, Class<T> targetType) {
        return FastjsonConverter.INSTANCE.convert(value, targetType);
    }

    protected abstract String getStringAttribute(String key);

    protected abstract void setStringAttribute(String key, String value);
}
