/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Resource.java
 * Modifier: yangxin
 * Modified: 2014-06-11 14:40
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.annotation;

import cn.gtmap.egovplat.security.Operation;

import java.lang.annotation.*;

/**
 * 资源定义.
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Resource {
    /**
     * 资源key
     */
    String key();

    /**
     * 资源名称
     */
    String name() default "";

    /**
     * 是否启用访问审计
     */
    boolean audit() default false;

    /**
     * 访问资源对应的操作
     */
    Operation op() default Operation.NULL;
}
