/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.cc.portal;

import cn.gtmap.cc.common.entity.sec.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2Sso;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestClientException;

@SpringBootApplication
@EnableOAuth2Sso
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Controller
public class App {
    @Autowired
    private OAuth2RestTemplate oAuth2RestTemplate;

    @RequestMapping(value={"/index"})
    public String index() {
        return "index";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/admin"})
    public String admin() {
        return "admin";
    }

    @RequestMapping(value={"/test"})
    @ResponseBody
    public Object test() {
        try {
            ResponseEntity responseEntity1 = this.oAuth2RestTemplate.exchange("http://localhost:8888/auth/user?page=0", HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            ResponseEntity responseEntity2 = this.oAuth2RestTemplate.exchange("http://localhost:8888/auth/user/4028da8b57606fdb0157606fefb80000", HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            User user = (User)this.oAuth2RestTemplate.getForObject("http://localhost:8888/auth/user/4028da8b57606fdb0157606fefb80000", User.class, new Object[0]);
            return user;
        }
        catch (RestClientException e) {
            return e.getLocalizedMessage();
        }
    }

    public static void main(String[] args) {
        SpringApplication.run(App.class, (String[])args);
    }

    @Bean
    public OAuth2RestTemplate oAuth2RestTemplate(OAuth2ProtectedResourceDetails resourceDetails, OAuth2ClientContext clientContext) {
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate(resourceDetails, clientContext);
        return oAuth2RestTemplate;
    }
}

