/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.core.support.freemarker.directive;

import cn.gtmap.common.core.support.freemarker.FmUtils;
import cn.gtmap.common.utils.Codecs;
import cn.gtmap.common.utils.RequestUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public abstract class AbstractResourceDirective
implements TemplateDirectiveModel,
ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourceDirective.class);
    public static final String BASE = "base";
    public static final String PATH = "path";
    public static final String VERSION = "version";
    private static final Set<String> IGNORES = Sets.newHashSet((Object[])new String[]{"base", "path", "version"});
    private ServletContext servletContext;
    private Map<String, FileItem> crc32Cache = Maps.newConcurrentMap();

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String base = FmUtils.getString(params, BASE, this.getDefaultBase());
        Object path = FmUtils.getParam(params, PATH);
        if (path == null) {
            throw new TemplateException("path is required", env);
        }
        StringBuilder attrSb = new StringBuilder();
        for (Map.Entry obj : params.entrySet()) {
            Map.Entry entry = obj;
            String key = (String)entry.getKey();
            if (IGNORES.contains(key)) continue;
            FmUtils.appendUE(attrSb, key, entry.getValue());
        }
        String attrString = attrSb.toString();
        Object version = FmUtils.getParam(params, VERSION);
        if (path instanceof String) {
            AbstractResourceDirective.out(env, this.getHtml(this.format(base, (String)path, version), attrString));
        } else if (path instanceof Iterable) {
            for (Object obj : (Iterable)path) {
                AbstractResourceDirective.out(env, this.getHtml(this.format(base, obj.toString(), version), attrString));
            }
        }
    }

    protected String getDefaultBase() {
        return "/static";
    }

    protected abstract String getHtml(String var1, String var2);

    private String format(String base, String path, Object version) {
        FileItem fi;
        StringBuilder sb = new StringBuilder(base);
        if (path.charAt(0) != '/') {
            sb.append("/");
        }
        sb.append(path);
        path = sb.toString();
        if (version != null) {
            if (version instanceof Boolean) {
                if (!((Boolean)version).booleanValue()) {
                    return RequestUtils.buildUrl(path, null);
                }
            } else {
                return RequestUtils.buildUrl(sb.append("?").append(version).toString(), null);
            }
        }
        if ((fi = this.crc32Cache.get(path)) == null) {
            File file;
            String filePath = this.servletContext.getRealPath(path);
            if (filePath != null && (file = new File(filePath)).exists()) {
                fi = new FileItem(file);
                this.crc32Cache.put(path, fi);
            }
        } else {
            fi.update();
        }
        if (fi != null) {
            sb.append("?").append(fi.crc32);
        } else {
            LOG.info("Web resouce [{}] not found", (Object)path);
        }
        return RequestUtils.buildUrl(sb.toString(), null);
    }

    private static String getCrc32(File file) {
        try {
            return Codecs.encode((int)FileUtils.checksumCRC32((File)file));
        }
        catch (IOException e) {
            return "";
        }
    }

    private static void out(Environment env, String html) throws IOException {
        env.getOut().write(html);
        env.getOut().write("\n");
    }

    static class FileItem {
        private File file;
        private long lastModified;
        private String crc32;

        FileItem(File file) {
            this.file = file;
            this.lastModified = file.lastModified();
            this.crc32 = AbstractResourceDirective.getCrc32(file);
        }

        private void update() {
            if (this.file.lastModified() > this.lastModified) {
                this.crc32 = AbstractResourceDirective.getCrc32(this.file);
            }
        }
    }
}

