/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.core.support.freemarker;

import cn.gtmap.common.core.support.freemarker.HttpScopesHashModel;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.SimpleHash;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerView
extends org.springframework.web.servlet.view.freemarker.FreeMarkerView {
    private TaglibFactory taglibFactory;
    private ServletContextHashModel servletContextHashModel;

    protected void initServletContext(ServletContext servletContext) throws BeansException {
        if (this.getConfiguration() != null) {
            this.taglibFactory = new TaglibFactory(servletContext);
        } else {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
            this.taglibFactory = config.getTaglibFactory();
        }
        GenericServletAdapter servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig());
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", (Throwable)ex);
        }
        this.servletContextHashModel = new ServletContextHashModel((GenericServlet)servlet, this.getObjectWrapper());
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        HttpScopesHashModel fmModel = new HttpScopesHashModel(this.getObjectWrapper(), this.getServletContext(), request);
        fmModel.put("JspTaglibs", this.taglibFactory);
        fmModel.put("Application", this.servletContextHashModel);
        fmModel.put("Session", this.buildSessionModel(request, response));
        fmModel.put("Request", new HttpRequestHashModel(request, response, this.getObjectWrapper()));
        HttpRequestParametersHashModel param = new HttpRequestParametersHashModel(request);
        fmModel.put("RequestParameters", param);
        fmModel.put("param", param);
        fmModel.put("base", request.getContextPath());
        fmModel.put("req", request);
        fmModel.putAll(model);
        return fmModel;
    }

    private HttpSessionHashModel buildSessionModel(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return new HttpSessionHashModel(session, this.getObjectWrapper());
        }
        return new HttpSessionHashModel(null, request, response, this.getObjectWrapper());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return FreeMarkerView.this.getBeanName();
        }

        public ServletContext getServletContext() {
            return FreeMarkerView.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.emptySet());
        }
    }

    private static class GenericServletAdapter
    extends GenericServlet {
        private GenericServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

