/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.core.support.datasource;

import cn.gtmap.common.core.support.datasource.Comment;
import cn.gtmap.common.core.support.mybatis.page.repository.Repo;
import cn.gtmap.common.utils.ClassUtil;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DataInit
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DataInit.class);
    private static String entityPackage;
    private static String sqlfilePath;
    @Autowired
    public Repo repository;

    public void afterPropertiesSet() throws Exception {
        this.initTableComment();
        this.initView();
    }

    private void initTableComment() {
        if (StringUtils.isBlank((CharSequence)entityPackage)) {
            return;
        }
        List<Class<?>> clsList = ClassUtil.getClasses(entityPackage);
        if (CollectionUtils.isNotEmpty(clsList)) {
            for (Class<?> cls : clsList) {
                if (!cls.isAnnotationPresent(Entity.class) || !cls.isAnnotationPresent(Table.class)) continue;
                Table table = cls.getAnnotation(Table.class);
                Object[] fields = cls.getDeclaredFields();
                if (!ArrayUtils.isNotEmpty((Object[])fields)) continue;
                for (Object field : fields) {
                    if (!((AccessibleObject)field).isAnnotationPresent(Comment.class) || !((AccessibleObject)field).isAnnotationPresent(Column.class)) continue;
                    Comment comment = ((Field)field).getAnnotation(Comment.class);
                    Column column = ((Field)field).getAnnotation(Column.class);
                    String sql = "comment on column " + table.name() + "." + column.name() + " is '" + comment.value() + "'";
                    this.executeSql(sql);
                }
            }
        }
    }

    private void initView() {
        List<String> sqlList = DataInit.loadSql();
        if (sqlList != null) {
            for (String sql : sqlList) {
                this.executeSql(sql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadSql() {
        if (StringUtils.isBlank((CharSequence)sqlfilePath)) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        InputStream inputStream = null;
        try {
            inputStream = DataInit.class.getResourceAsStream(sqlfilePath);
            if (inputStream != null) {
                StringBuilder builder = new StringBuilder();
                byte[] buff = new byte[1024];
                int byteRead = 0;
                while ((byteRead = inputStream.read(buff)) != -1) {
                    builder.append(new String(buff, 0, byteRead));
                }
                String[] sqlArr = builder.toString().split(";");
                for (int i = 0; i < sqlArr.length; ++i) {
                    String sql = sqlArr[i].replaceAll("--.*", "").trim();
                    if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                    sqlList.add(sql);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return sqlList;
    }

    private void executeSql(String sql) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sql", sql);
        this.repository.update("updateBySql", paramMap);
    }

    public static void setEntityPackage(String entityPackage) {
        DataInit.entityPackage = entityPackage;
    }

    public static void setSqlfilePath(String sqlfilePath) {
        DataInit.sqlfilePath = sqlfilePath;
    }
}

