/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.utils;

import cn.gtmap.common.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.spring.Container;
import de.innosystec.unrar.Archive;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static boolean zip(String zipFileName, File inputFile) throws Exception {
        boolean result = false;
        ZipArchiveOutputStream out = null;
        try {
            out = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFileName));
            out.setEncoding("GBK");
            FileUtil.zip(out, inputFile, "");
            result = true;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return result;
    }

    private static void zip(ZipArchiveOutputStream out, File f, String base) throws Exception {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(base + "/"));
            out.closeArchiveEntry();
            base = base.length() == 0 ? "" : base + "/";
            for (int i = 0; i < fl.length; ++i) {
                FileUtil.zip(out, fl[i], base + fl[i].getName());
            }
        } else {
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(base));
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.closeArchiveEntry();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public static String unRarFile(String srcRarPath, String dstDirectoryPath) {
        String dirName = null;
        File dstDiretory = new File(dstDirectoryPath);
        if (!dstDiretory.exists()) {
            dstDiretory.mkdirs();
        }
        Archive a = null;
        try {
            a = new Archive(new File(srcRarPath));
            if (a != null) {
                FileHeader fh = a.nextFileHeader();
                while (fh != null) {
                    if (fh.isDirectory()) {
                        String dirFullPath = "";
                        String dir = "";
                        if (fh.getFileNameW() == null || fh.getFileNameW().equals("")) {
                            dirFullPath = dstDirectoryPath + fh.getFileNameString();
                            dir = fh.getFileNameString();
                        } else {
                            dirFullPath = dstDirectoryPath + fh.getFileNameW();
                            dir = fh.getFileNameW();
                        }
                        if (dirFullPath != null && !dirFullPath.equals("")) {
                            System.out.println(dirFullPath);
                            File fol = new File(dirFullPath);
                            fol.mkdirs();
                        }
                        if (dirName == null || dirName.equals("")) {
                            dirName = dir;
                        }
                    } else {
                        String fileFullPath = "";
                        fileFullPath = fh.getFileNameW() == null || fh.getFileNameW().equals("") ? dstDirectoryPath + fh.getFileNameString().trim() : dstDirectoryPath + fh.getFileNameW().trim();
                        if (fileFullPath != null && !fileFullPath.equals("")) {
                            File out = new File(fileFullPath);
                            try {
                                if (!out.exists()) {
                                    if (!out.getParentFile().exists()) {
                                        out.getParentFile().mkdirs();
                                    }
                                    out.createNewFile();
                                }
                                FileOutputStream os = new FileOutputStream(out);
                                a.extractFile(fh, (OutputStream)os);
                                os.close();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    fh = a.nextFileHeader();
                }
                a.close();
            }
            if (dirName == null) {
                dirName = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dirName = null;
        }
        if (dirName != null) {
            dirName = dirName.replace("\\", "/");
        }
        System.out.println(dirName);
        return dirName;
    }

    public static synchronized String unzip(String zipFilename, String unzipDir) throws IOException {
        File srcFile = new File(zipFilename);
        return FileUtil.unzip(srcFile, unzipDir);
    }

    public static synchronized String unzip(File srcfile, String unzipDir) throws IOException {
        boolean flag = false;
        String dirName = null;
        try {
            File outFile = new File(unzipDir);
            if (!outFile.exists()) {
                outFile.mkdirs();
            }
            ZipFile zipFile = new ZipFile(srcfile, "GBK");
            Enumeration en = zipFile.getEntries();
            ZipArchiveEntry zipEntry = null;
            while (en.hasMoreElements()) {
                File f;
                zipEntry = (ZipArchiveEntry)en.nextElement();
                if (zipEntry.isDirectory()) {
                    String tempDirName = "";
                    tempDirName = zipEntry.getName();
                    tempDirName = URLDecoder.decode(tempDirName, "utf-8");
                    tempDirName = tempDirName.substring(0, tempDirName.length() - 1);
                    f = new File(outFile.getPath() + File.separator + tempDirName);
                    f.mkdirs();
                    if (dirName != null && !dirName.equals("")) continue;
                    dirName = tempDirName;
                    continue;
                }
                String strFilePath = outFile.getPath() + File.separator + zipEntry.getName();
                f = new File(strFilePath);
                if (!f.exists()) {
                    String[] arrFolderName = zipEntry.getName().split("/");
                    String strRealFolder = "";
                    for (int i = 0; i < arrFolderName.length - 1; ++i) {
                        strRealFolder = strRealFolder + arrFolderName[i] + File.separator;
                    }
                    strRealFolder = outFile.getPath() + File.separator + strRealFolder;
                    File tempDir = new File(strRealFolder);
                    tempDir.mkdirs();
                }
                f.createNewFile();
                InputStream in = zipFile.getInputStream(zipEntry);
                FileOutputStream out = new FileOutputStream(f);
                try {
                    int c;
                    byte[] by = new byte[1024];
                    while ((c = in.read(by)) != -1) {
                        out.write(by, 0, c);
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    out.close();
                    in.close();
                }
                if (dirName != null && !dirName.equals("")) continue;
                dirName = strFilePath;
            }
            flag = true;
            if (dirName == null) {
                dirName = "";
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + "\u89e3\u538b\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff01");
            dirName = null;
        }
        return dirName;
    }

    public static boolean deleteDirectory(String sPath) throws Exception {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = false;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        flag = false;
        if (dirFile.delete()) {
            flag = true;
        }
        return flag;
    }

    public static boolean deleteFile(String sPath) throws Exception {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static boolean copyFile(String oldPath, String newPath) {
        boolean isok = false;
        try {
            File file = new File(newPath);
            if (!file.exists()) {
                FileUtil.createFiles(newPath);
            }
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldfile);
                FileOutputStream fs = new FileOutputStream(file);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
                isok = true;
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
        return isok;
    }

    public static Boolean createFiles(String path) {
        Boolean flag = false;
        File file = null;
        if (!path.equals("") || path != null) {
            file = new File(path);
            if (!file.exists()) {
                if (file.isDirectory()) {
                    file.mkdirs();
                } else {
                    File fileDir = new File(file.getParent());
                    fileDir.mkdirs();
                    System.out.println("\u4e0a\u5c42\u6587\u4ef6\u5939\uff1a " + fileDir);
                    try {
                        flag = file.createNewFile();
                        System.out.println("\u6587\u4ef6\u540d\u79f0\uff1a" + file);
                    }
                    catch (IOException e) {
                        System.out.println("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("\u3010" + path + "\u3011\uff1a" + "\u8be5\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
            }
        }
        return flag;
    }

    public static boolean DeleteFolder(String sPath) throws Exception {
        boolean flag = false;
        File file = new File(sPath);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile(sPath);
        }
        return FileUtil.deleteDirectory(sPath);
    }

    public static Boolean createDirectory(String dirPath, boolean isreplace) throws Exception {
        Boolean flag;
        block5: {
            flag = false;
            if (StringUtils.isNotBlank((CharSequence)dirPath)) {
                try {
                    File file = new File(dirPath);
                    if (file.exists()) {
                        if (isreplace) {
                            FileUtil.DeleteFolder(dirPath);
                            file.mkdirs();
                            return true;
                        }
                        break block5;
                    }
                    file.mkdirs();
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    public static String findFileByName(String dirName, String fileName) {
        File file = new File(dirName);
        return FileUtil.findFileByName(file, fileName);
    }

    public static String findFileByName(File dir, String fileName) {
        File[] files;
        String filePath = "";
        if (dir != null && dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    filePath = FileUtil.findFileByName(files[i], fileName);
                } else if (files[i].getName().equalsIgnoreCase(fileName)) {
                    filePath = files[i].getAbsolutePath();
                }
                if (StringUtils.isNotBlank((CharSequence)filePath)) break;
            }
        }
        return filePath;
    }

    public static void createFileCenterNodeByFolder(String proID, String dirName, String spacecode) {
        File dirFile;
        if (StringUtils.isNotBlank((CharSequence)dirName) && (dirFile = new File(dirName)) != null && dirFile.exists() && dirFile.isDirectory()) {
            NodeService nodeService = (NodeService)Container.getBean((String)"NodeService");
            FileService fileService = (FileService)Container.getBean((String)"FileService");
            Space space = nodeService.getWorkSpace(spacecode, true);
            Node node = nodeService.getNode(space.getId(), proID, true);
            Integer nodeId = node.getId();
            String token = nodeService.getToken(node);
            Node nodeChild = nodeService.getNode(nodeId, dirFile.getName(), false);
            if (nodeChild != null) {
                nodeService.remove(nodeChild.getId());
            }
            FileUtil.createFileCenterNodeByFile(dirFile, node, nodeService, fileService);
        }
    }

    public static void createFileCenterNodeByFile(File file, Node node, NodeService nodeService, FileService fileService) {
        if (file != null && file.exists()) {
            try {
                Node fileNode = FileUtil.getOrCreateNode(node.getId(), file.getName(), nodeService);
                System.out.println(fileNode.getName());
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files != null && files.length > 0) {
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                FileUtil.createFileCenterNodeByFile(files[i], fileNode, nodeService, fileService);
                                continue;
                            }
                            if (!files[i].isFile()) continue;
                            fileService.uploadFile(files[i], fileNode.getId(), null, null, true, false);
                        }
                    }
                } else if (file.isFile()) {
                    fileService.uploadFile(file, fileNode.getId(), null, null, true, false);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static Node getOrCreateNode(Integer nid, String fName, NodeService nodeService) {
        Node nodeChild = null;
        try {
            nodeChild = nodeService.getNode(nid, fName, true);
        }
        catch (Exception e) {
            nodeChild = nodeService.createNode(nid, fName);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            nodeService.save(nodeChild);
        }
        if (nodeChild == null) {
            nodeChild = nodeService.getNode(nid, fName, true);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            nodeService.save(nodeChild);
        }
        return nodeChild;
    }

    public static List<String> getFileName(String dirPath, String type, String name) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        File dirFile = new File(dirPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        type = type.toLowerCase();
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                String filename = files[i].getAbsolutePath();
                int point = filename.lastIndexOf(".") + 1;
                String filetype = filename.substring(point, filename.length());
                if ((filetype = filetype.toLowerCase()) == null || StringUtils.indexOf((CharSequence)type, (CharSequence)filetype) <= -1) continue;
                if (StringUtils.isNotBlank((CharSequence)name) && filename.indexOf(name) > -1) {
                    strList = new ArrayList();
                    strList.add(filename);
                    break;
                }
                strList.add(filename);
                continue;
            }
            if (!files[i].isDirectory()) continue;
        }
        return strList;
    }

    public static List<HashMap<String, String>> getFileMapList(String dirPath, String type, String name) throws Exception {
        ArrayList<HashMap<String, String>> strList = new ArrayList<HashMap<String, String>>();
        File dirFile = new File(dirPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        type = type.toLowerCase();
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                HashMap<String, String> fileMap = new HashMap<String, String>();
                String filename = files[i].getName();
                String filepath = files[i].getAbsolutePath();
                int point = filename.lastIndexOf(".") + 1;
                String filetype = filename.substring(point, filename.length());
                filename = filename.substring(0, point - 1);
                if ((filetype = filetype.toLowerCase()) == null || StringUtils.indexOf((CharSequence)type, (CharSequence)filetype) <= -1) continue;
                fileMap.put("filename", filename);
                fileMap.put("filetype", filetype);
                fileMap.put("filepath", filepath);
                if (StringUtils.isNotBlank((CharSequence)name) && filename.indexOf(name) > -1) {
                    strList = new ArrayList();
                    strList.add(fileMap);
                    break;
                }
                strList.add(fileMap);
                continue;
            }
            if (!files[i].isDirectory()) continue;
        }
        return strList;
    }

    public static Integer createFileCenterFolder(String proID, String foldName) throws Exception {
        Space space = null;
        Integer nodeId = null;
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"NodeService");
            space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
            Node prjNode = nodeService.getNode(space.getId(), proID, true);
            Integer proNodeid = prjNode.getId();
            Node cityNode = FileUtil.getOrCreateNode(proNodeid, foldName, nodeService);
            nodeId = cityNode.getId();
        }
        catch (Exception e) {
            System.out.println("\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return nodeId;
    }

    public static String getXmlFileName(String dir, String fileName) {
        String filename = "";
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        boolean flag = false;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !StringUtils.equals((CharSequence)fileName, (CharSequence)(filename = files[i].getName()))) continue;
            flag = true;
            break;
        }
        if (!flag) {
            filename = "";
        }
        return filename;
    }

    public static String getXmlFileName(String dir) {
        String filename = "";
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        boolean flag = false;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int point;
            String filetype;
            if (!files[i].isFile() || (filetype = (filename = files[i].getAbsolutePath()).substring(point = filename.lastIndexOf(".") + 1, filename.length())) == null || !filetype.equalsIgnoreCase("xml")) continue;
            flag = true;
            break;
        }
        if (!flag) {
            filename = "";
        }
        return filename;
    }

    public static String getEgovHomePath(String path) {
        String dirPath = "";
        try {
            dirPath = AppConfig.getConfHome((String[])new String[0]) + "/" + path + "/";
            if (dirPath.startsWith("zip")) {
                dirPath = dirPath.substring(4);
            } else if (dirPath.startsWith("file")) {
                dirPath = dirPath.substring(6);
            } else if (dirPath.startsWith("jar")) {
                dirPath = dirPath.substring(10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dirPath;
    }

    public static byte[] getBytesFromFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean buildFr3File(String fileDir, String filename, HttpServletRequest request) throws Exception {
        try {
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                String tempFr3Path = FileUtil.getProjectPath(request) + "\\common\\print\\" + fileDir;
                File tempFr3File = new File(tempFr3Path + "\\" + filename);
                if (tempFr3File.exists()) {
                    return true;
                }
                String dirPath = FileUtil.getEgovHomePath("busimap/print");
                File fr3File = new File(dirPath + "/" + fileDir + "/" + filename);
                if (!fr3File.exists()) {
                    dirPath = FileUtil.getProjectPath(request) + "WEB-INF\\classes\\META-INF\\conf\\busimap\\print";
                    fr3File = new File(dirPath + "/" + fileDir + "/" + filename);
                }
                if (fr3File.exists()) {
                    File tmpFile;
                    File tmpDir = new File(tempFr3Path);
                    if (!tmpDir.exists()) {
                        FileUtil.createDirectory(tempFr3Path, false);
                    }
                    if (!(tmpFile = new File(tempFr3Path + "\\" + filename)).exists()) {
                        FileUtil.copyFile(dirPath + "/" + fileDir + "/" + filename, tempFr3Path + "\\" + filename);
                    }
                    if ((tmpFile = new File(tempFr3Path + "\\" + filename)).exists()) {
                        return true;
                    }
                }
            } else {
                System.out.println("\u6253\u5370\u6a21\u677f\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String copyCadFile(String curFilePath, String filename, HttpServletRequest request) throws Exception {
        try {
            File file;
            if (StringUtils.isNotBlank((CharSequence)curFilePath) && (file = new File(curFilePath)).exists()) {
                File tmpFile;
                String tempFr3Path = FileUtil.getProjectPath(request) + "\\common\\temp";
                File tmpDir = new File(tempFr3Path);
                if (!tmpDir.exists()) {
                    FileUtil.createDirectory(tempFr3Path, false);
                }
                if (StringUtils.isBlank((CharSequence)filename)) {
                    filename = file.getName();
                }
                if (!(tmpFile = new File(tempFr3Path + "\\" + filename)).exists()) {
                    FileUtil.copyFile(curFilePath, tempFr3Path + "\\" + filename);
                    return filename;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getExtension(String filename, String defExt) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return defExt;
    }

    public static String getJsonFilePath(String filename) throws Exception {
        try {
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                String dirPath = FileUtil.getEgovHomePath("gtbusi/json");
                String filePath = dirPath + "/" + filename + ".json";
                File file = new File(filePath);
                if (!file.exists()) {
                    dirPath = FileUtil.getProjectPath(null) + "WEB-INF\\classes\\META-INF\\conf\\gtbusi\\json";
                    filePath = dirPath + "/" + filename + ".json";
                    file = new File(filePath);
                }
                if (file.exists()) {
                    return filePath;
                }
            } else {
                System.out.println("\u6253\u5370\u6a21\u677f\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readJsonFile(String path) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            File file;
            if (path.indexOf("file:/") > -1) {
                path = path.substring(path.indexOf("file:/") + 6);
            }
            if (!(file = new File(path)).exists()) {
                throw new FileNotFoundException();
            }
            BufferedReader bufferedReader = null;
            StringBuffer config = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String tmp = null;
                while ((tmp = bufferedReader.readLine()) != null) {
                    config.append(tmp);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)config.toString())) {
                return JSON.parse((String)config.toString());
            }
        }
        return null;
    }

    public static String getTempPath(HttpServletRequest request, String type) {
        String path = request.getSession().getServletContext().getRealPath("/");
        if (path == null || path.equals("")) {
            path = System.getProperty("user.dir").replace("bin", "webapps") + "\\gtbusi\\";
        }
        path = path.replace("\\webapps\\gtbusi\\", "\\temp\\");
        path = path + type + "\\";
        GregorianCalendar today = new GregorianCalendar();
        path = path + CalendarUtil.sdf_time.format(today.getTime()) + "\\";
        return path;
    }

    public static String getProjectPath(HttpServletRequest request) {
        String path = null;
        path = request == null ? System.getProperty("user.dir").replace("bin", "webapps") + "\\gtbusi\\" : request.getSession().getServletContext().getRealPath("/");
        return path;
    }

    public static String getTempPath(String type) {
        String path = System.getProperty("user.dir").replace("bin", "webapps") + "\\gtbusi\\";
        path = path.replace("\\webapps\\gtbusi\\", "\\temp\\");
        path = path + type + "\\";
        GregorianCalendar today = new GregorianCalendar();
        path = path + CalendarUtil.sdf_time.format(today.getTime()) + "\\";
        return path;
    }

    public static File getFileByMvc(MultipartFile multipartFile, HttpServletRequest request, String dirName) {
        String path = request.getSession().getServletContext().getRealPath("static\\tmp\\" + dirName);
        File dirPath = new File(path);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        String filename = UUIDGenerator.generate() + "." + FileUtil.getExtension(multipartFile.getOriginalFilename(), "");
        String filePath = path + "\\" + filename;
        File file = new File(filePath);
        try {
            multipartFile.transferTo(file);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static String encodeBase64File(String path) throws Exception {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{path})) {
            File file = new File(path);
            return null;
        }
        return null;
    }

    public static String encodeBase64File(File file) throws Exception {
        if (file != null && file.exists()) {
            return FileUtil.encodeBase64File(new FileInputStream(file));
        }
        return null;
    }

    public static String encodeBase64File(FileInputStream fileInputStream) throws Exception {
        return FileUtil.ioToBase64(fileInputStream);
    }

    public static String ioToBase64(FileInputStream fileInputStream) throws IOException {
        String strBase64 = null;
        try {
            byte[] bytes = new byte[fileInputStream.available()];
            fileInputStream.read(bytes);
            strBase64 = new BASE64Encoder().encode(bytes);
            fileInputStream.close();
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return strBase64;
    }

    public static void base64ToIo(String strBase64, String path) throws IOException {
        String string = strBase64;
        try {
            byte[] bytes = new BASE64Decoder().decodeBuffer(string);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            FileOutputStream out = new FileOutputStream(path);
            int bytesum = 0;
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                bytesum += byteread;
                out.write(buffer, 0, byteread);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

