/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     HtmlUtils.java
 * Modifier: yangxin
 * Modified: 2014-06-26 19:46
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.common.utils;

import com.google.common.html.HtmlEscapers;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-26
 */
public final class HtmlUtils {

    public static String escape(Object html) {
        if (html == null) {
            return StringUtils.EMPTY;
        }
        return HtmlEscapers.htmlEscaper().escape(html.toString());
    }

    public static String unescape(Object html) {
        if (html == null) {
            return StringUtils.EMPTY;
        }
        return StringEscapeUtils.unescapeHtml4(html.toString());
    }

    private HtmlUtils() {
    }
}
