package cn.gtmap.common.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.gtmap.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.common.core.support.mybatis.page.model.Page;
import cn.gtmap.common.core.support.mybatis.page.repository.Repo;
import cn.gtmap.common.service.BaseService;
import cn.gtmap.common.utils.AnnotationsUtils;
import cn.gtmap.common.utils.ClassUtils;

import com.alibaba.fastjson.JSON;

/**
 * java对象基础操作类
* @文件名 BaseServiceImpl.java
 * @作者 卢向伟
 * @创建日期 2015年12月12日
 * @创建时间 下午2:53:19 
 * @版本号 V 1.0
 */
@Service
public class BaseServiceImpl<E,ID> implements BaseService<E,ID> {
	@Autowired
	public EntityMapper entryMapper;
	@Autowired
	public Repo repository;

    private Class<E> entityClass;
    
    public BaseServiceImpl() {
    	entityClass = ClassUtils.getGenericParameter0(getClass());
    }

    public E findById(ID id) {
		if (id != null) {
			return entryMapper.selectByPrimaryKey(entityClass, id);
		} else {
			return null;
		}
	}

	/**
	 * 根据一对一关系的外键查找对象
	 * @param id
	 * @return E
	 */
    //@Deprecated
	public E findByForeignId(String id) {
		if (id != null) {
			return entryMapper.selectByForeignKey(entityClass, id);
		} else {
			return null;
		}
	}

	@Override
	public E findByForeignId(String id, String value) {
		if (StringUtils.isNotBlank(id) && StringUtils.isNotBlank(value)) {
			Map<String, String> map = new HashMap<String, String>();
			map.put(id, value);
			List<E> list =  findListByForeignId(map);
			if (CollectionUtils.isNotEmpty(list)) {
				return list.get(0);
			}
		}
		return null;
	}

	/**
	 * 根据一对多关系的外键查找对象
	 * 此处排序的顺序是根据实体类中的顺序来的，如果有多字段符合排序，请按照顺序组织
	 * 比如，对字段B、A、C字段依次注解，最终的排序效果就是order by B,A,C
	 * 注解：@OrderBy，引用javax.persistence.OrderBy;
	 * 默认正序，可以配置倒叙，比如：@OrderBy("DESC")
	 * @param map 只接受Map、HashMap、LinkedHashMap类型参数
	 * @param <E> 返回对象集合
	 * @return
	 */
	public <E> List<E> findListByForeignId(Map map) {
		if (map != null) {
			return (List<E>)entryMapper.selectListByForeignKey(entityClass, map);
		} else {
			return null;
		}
	}

	@Override
	public <E> List<E> findListByForeignId(String id, String value) {
		if (StringUtils.isNoneBlank(id) && StringUtils.isNoneBlank(value)) {
			Map<String, String> map = new HashMap<String, String>();
			map.put(id, value);
			return findListByForeignId(map);
		}
		return null;
	}

	public HashMap findMapById(ID id) throws Exception{
		HashMap map = new HashMap();
		if (id != null && StringUtils.isNotBlank(id.toString())) {
			E proj = findById(id);
			String jsonStr = JSON.toJSONString(proj);
			map = JSON.parseObject(jsonStr,HashMap.class);
			//map.put("pzSj", CalendarUtil.getDateAfter(proj.getPzSj(),(1)));
		}
		return map;
	}

	public HashMap findMapByForeignId(String fkId) throws Exception{
		HashMap map = new HashMap();
		if (StringUtils.isNotBlank(fkId)) {
			E proj = findByForeignId(fkId);
			String jsonStr = JSON.toJSONString(proj);
			map = JSON.parseObject(jsonStr,HashMap.class);
			//map.put("pzSj", CalendarUtil.getDateAfter(proj.getPzSj(),(1)));
		}
		return map;
	}


    @Transactional(rollbackFor=Exception.class)
	public void insert(E obj){
		if (obj != null) {
			entryMapper.insert(obj);
		}
	}
    public void save(E obj){
    	insert(obj);
	}
	@Transactional(rollbackFor=Exception.class)
	public void update(E obj){
		if (obj != null) {
			entryMapper.updateByPrimaryKey(obj);
		}
	}
	@Transactional(rollbackFor=Exception.class)
	public void delete(E obj){
		if (obj != null) {
			String id = AnnotationsUtils.getIdKeyValue(obj).toString();
//			entryMapper.delete(obj);
			entryMapper.deleteByPrimaryKey(entityClass,id);
		}
	}
	@Transactional(rollbackFor=Exception.class)
	public void deleteById(ID id){
		if (id != null) {
			entryMapper.deleteByPrimaryKey(entityClass,id);
		}
	}

	@Transactional(rollbackFor=Exception.class)
	public void deleteByForeignKey(Map map){
		if (map != null) {
			boolean isOk = true;
			for (Object key : map.keySet()) {
				if (map.get(key) == null || StringUtils.isBlank(MapUtils.getString(map,key))){
					isOk = false;
					break;
				}
			}
			if (isOk) {
				entryMapper.deleteByForeignKey(entityClass,map);
			}
		}
	}

	@Transactional(rollbackFor=Exception.class)
	@Override
	public void deleteByForeignKey(String key, String value) {
		if (StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value)) {
			Map<String, String> map = new HashMap<String, String>();
			map.put(key, value);
			deleteByForeignKey(map);
		}
	}

	@Transactional(rollbackFor=Exception.class)
	public void deleteByIds(String ids){
		if (ids != null) {
			String[] id = ids.toString().split(",");
			for (int i = 0; i < id.length; i++) {
				entryMapper.deleteByPrimaryKey(entityClass,id[i]);
			}
		}
	}

	@Override
	public <T> Page<T> getPage(String statement, String paramString, Pageable pageable) throws Exception {
		HashMap<String, Object> map = new HashMap<String, Object>();
		if (StringUtils.isNotBlank(paramString)){
			paramString = java.net.URLDecoder.decode(paramString,"UTF-8");
			map.putAll(JSON.parseObject(paramString));
		}
		return repository.selectPaging(statement, map, pageable);
	}

	@Override
	public <T> List<T> getHashMapList(String statement, HashMap map) throws Exception {
		return repository.selectList(statement,map);
	}

	@Override
	public <T> T getHashMap(String statement, HashMap map) throws Exception {
		return repository.selectOne(statement,map);
	}

	public <T> T BaseServiceImpl(String statement, HashMap map) throws Exception {
		return repository.selectOne(statement,map);
	}
}
