package cn.gtmap.common.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Pageable;

import cn.gtmap.common.core.support.mybatis.page.model.Page;

/**
 * Created with IntelliJ IDEA.
 * User: deery
 * Date: 13-10-23
 * Time: 上午5:42
 * To change this template use File | Settings | File Templates.
 */
public interface BaseService<E,ID> {
    
	public E findById(ID id);

	public E findByForeignId(String id);

	/**
	 * 根据一个外键查找对象（对应字段需要加注解@ForeignKey）
	 * @param id 字段名
	 * @param value 字段值
	 * @return
	 */
	public E findByForeignId(String id, String value);

	/**
	 * 根据一对多关系的外键查找对象
	 * 此处排序的顺序是根据实体类中的顺序来的，如果有多字段符合排序，请按照顺序组织
	 * 比如，对字段B、A、C字段依次注解，最终的排序效果就是order by B,A,C
	 * 注解：@OrderBy，引用javax.persistence.OrderBy;
	 * 默认正序，可以配置倒叙，比如：@OrderBy("DESC")
	 * @param map 只接受Map、HashMap、LinkedHashMap类型参数
	 * @param <E> 返回对象集合
	 * @return
	 */
	public <E> List<E> findListByForeignId(Map map);
	/**
	 * 根据一个外键值查找对象（对应字段需要加注解@ForeignKey）
	 * @param id 字段名
	 * @param value 字段值
	 * @return
	 */
	public <E> List<E> findListByForeignId(String id, String value);

	public HashMap findMapById(ID id) throws Exception;

	public HashMap findMapByForeignId(String fkId) throws Exception;

	public void insert(E obj);
	public void save(E obj);
	public void update(E obj);
	public void delete(E obj);
	public void deleteById(ID id);
	public void deleteByForeignKey(Map map);
	/**
	 * 根据一个外键删除对象（对应字段需要加注解@ForeignKey）
	 * @param key 字段名
	 * @param value 字段值
	 */
	public void deleteByForeignKey(String key, String value);
	public void deleteByIds(String ids);
	public <T> Page<T> getPage(String statement, String paramString, Pageable pageable) throws Exception;

	//测试用
	public <T> List<T> getHashMapList(String statement, HashMap map) throws Exception;

	//测试用
	public <T> T getHashMap(String statement, HashMap map)throws Exception;
}
