package cn.gtmap.common.model;

//import javax.persistence.Entity;


import org.apache.commons.lang3.StringUtils;

/**
 * 公共类Vo，用于List中的name、value(name、id)
 * name对应名称,value对应id
 *
 * @文件名 PublicVo.java
 * @作者 卢向伟
 * @创建日期 May 31, 2011
 * @创建时间 2:10:43 PM
 * @版本号 V 1.0
 */
//@Entity
public class PublicEntity implements Comparable<PublicEntity> {
    private String id;//实际数据
    private String text;//用于显示
    private String parentId;//父类id

    public PublicEntity() {
        super();
    }

    public PublicEntity(String value, String name, String parentId) {
        super();
        if (StringUtils.isBlank(value)) {
            value = "";
        }
        if (StringUtils.isBlank(name)) {
            name = "";
        }
        if (StringUtils.isBlank(parentId)) {
            parentId = "";
        }
        this.id = value.replace("null", "");
        this.text = name.replace("null", "");
        this.parentId = parentId.replace("null", "");
    }

    /**
     * 参数显示数据
     *
     * @return
     */
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    /**
     * 参数保存数据
     *
     * @return
     */
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int compareTo(PublicEntity arg0) {
        if (arg0 == null) {
            return 1;
        } else {
            return this.getId().compareTo(arg0.getId());//升序排列
            //			return obj.getXm_xcsj().compareTo(this.getXm_xcsj());//倒叙
        }

    }


    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}
