
package cn.gtmap.common.core.web;

import cn.gtmap.common.core.i18n.NLS;
import cn.gtmap.common.utils.ExUtils;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.Collections;
import java.util.Map;

import static cn.gtmap.common.core.web.Vars.MSG;
import static cn.gtmap.common.core.web.Vars.RET;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version V1.0, 16-3-15
 * @description controller基类，提供常用的错误或成功返回值
 */
@Controller
public abstract class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    protected final String getMsg(String key) {
        return NLS.get(key);
    }

    protected final String getMsg(String key, Object... args) {
        return NLS.get(key, args);
    }

    protected static void success(RedirectAttributes ra, String msg) {
        ra.addFlashAttribute(RET, true);
        ra.addFlashAttribute(MSG, msg);
    }

    protected static void success(RedirectAttributes ra) {
        ra.addFlashAttribute(RET, true);
    }

    protected static void fail(Model model, String msg) {
        model.addAttribute(RET, false);
        model.addAttribute(MSG, msg);
    }

    protected static void fail(Model model, Exception ex) {
        model.addAttribute(RET, false);
        model.addAttribute(MSG, ex.getMessage());
    }

    protected static void fail(Model model) {
        model.addAttribute(RET, false);
    }

    @SuppressWarnings("unchecked")
    protected static Map<String, Object> success() {
        return (Map) Collections.singletonMap(RET, true);
    }

    protected static Map<String, Object> fail(String message) {
        Map<String, Object> map = Maps.newHashMapWithExpectedSize(2);
        map.put(RET, false);
        map.put(MSG, message);
        return map;
    }

    protected static Map<String, Object> fail(Exception ex) {
        return ExUtils.toMap(ex);
    }
}
