/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DateToStringConverter.java
 * Modifier: yangxin
 * Modified: 2014-06-13 22:55
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.common.core.support.spring;

import cn.gtmap.common.utils.DateUtils;
import org.springframework.core.convert.converter.Converter;

import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-13
 */
public class DateToStringConverter implements Converter<Date, String> {
    @Override
    public String convert(Date source) {
        return DateUtils.DATETIME_FORMAT.format(source);
    }
}
