/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ErrorCode.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.common.core.ex;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 11-11-20
 */
public interface ErrorCode {

    /**
     * 自定义错误起始值
     */
    static final int CUSTOM = 100;

    /**
     * 请求成功执行
     */
    static final int SUCCEED = 0;

    /**
     * 内部异常
     */
    static final int SERVER_EX = 1;

    /**
     * 空指异常
     */
    static final int NPE_EX = 2;

    /**
     * 内存溢出错误
     */
    static final int OOM_ERROR = 3;

    /**
     * 堆栈溢出错误
     */
    static final int SOF_ERROR = 4;

    /**
     * 功能尚未实现
     */
    static final int NOT_IMPL = 5;

    /**
     * 不支持此操作
     */
    static final int UN_SUPPORTED = 6;

    /**
     * 类访问异常
     */
    static final int CLASS_EX = 7;

    /**
     * IO异常
     */
    static final int IO_EX = 8;

    /**
     * 网络异常
     */
    static final int SOCKET_EX = 9;

    /**
     * 数据库访问异常
     */
    static final int DB_EX = 10;

    /**
     * 缓存异常
     */
    static final int CACHE_EX = 11;

    /**
     * 状态异常
     */
    static final int ILLEGAL_STATE = 51;

    /**
     * 非法参数
     */
    static final int ILLEGAL_ARG = 52;

    /**
     * 非法参数格式
     */
    static final int ILLEGAL_ARG_FORMAT = 53;

    /**
     * 参数不完整
     */
    static final int MISSING_ARG = 54;

    /**
     * 参数校验错误
     */
    static final int VALIDATION_EX = 55;

    /**
     * 实体对象异常
     */
    static final int ENTITY_EX = 70;

    /**
     * 实体对象未找到
     */
    static final int ENTITY_NOT_FOUND = 71;

    /**
     * 实体对象已存在
     */
    static final int ENTITY_EXISTS = 72;

    /**
     * 实体对象缺少对象标识(ID)
     */
    static final int ENTITY_NO_ID = 73;

    /**
     * 消息队列错误
     */
    static final int MQ_EX = 80;

    /**
     * 模板错误
     */
    static final int TPL_EX = 81;
}
