package cn.gtmap.common.OracleOpera;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import com.alibaba.fastjson.JSON;

/***
 *  2014-07-21日：
 *  oracle数据库， 表结构查询 ，字段信息查询，字段注释查询
 *  表字段查询 all_tab_columns
 *  表字段注释查询 all_col_comments
 *
 */
public class OracleTable {
    private static final String entityPath = "d://cn/gtmap/busi/model/";//创建路径
    private static final String packagePath = "cn.gtmap.busi.model";//创建包路径
    private static final String DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";//数据库驱动地址
    private static final String DATABASE_URL = "jdbc:oracle:thin:@127.0.0.1:1521:orcl";//数据库连接参数
    private static final String DATABASE_USER = "gtis_test";//数据库用户名
    private static final String DATABASE_PASSWORD = "gtis_test";//数据库密码
    private static Connection con = null;

    private static HashMap<String,String> fieldTypeMap = new HashMap<String,String>();

    public static Connection getConnection() {
        try {
            Class.forName(DRIVER_CLASS);
            con= DriverManager.getConnection(DATABASE_URL,DATABASE_USER,DATABASE_PASSWORD);
            return con;
        } catch (Exception ex) {
            System.out.println("2:"+ex.getMessage());
        }
        return con;
    }
    public static void main(String[] args) throws SQLException {
        fieldTypeMap = initFieldTypeMap();

        //createXml该参数的意思是是否生成建设用地报盘软件所需要的xml格式文件，只针对报批系统

        /**
         * 根据map来创建实体类，map的key为表名，value为注释
         */
        HashMap<String,String> tableMap = new HashMap<String, String>();
        /*tableMap.put("BL_PROJ_BUILD","建设用地报件基本信息表");
        tableMap.put("BL_SURVEY_BOUND","勘测定界成果表");*/

        //tableMap.put("PF_WORKFLOW_INSTANCE_REL","工作流关联表");

        //createEntityOrXmlByTableMap(false,tableMap);

        tableMap.put("SQ_REL_BDCDJ_GD","不动产登记信息表");
        tableMap.put("SQ_BDCDJ","勘测定界成果表");
        createEntityOrXmlByTableMap(false,tableMap);
        /**
         * 将数据库中所有表都转为实体类
         */
        //createAllEntityOrXml(false);//当为true的时候，直接生成所有表的xml
    }

    public static void createAllEntityOrXml(boolean createXml) throws SQLException{
        List<TableData> tableDataList = new ArrayList<TableData>();
        try {
            getConnection();
            //获取所有数据库表
            Statement stmt = con.createStatement();
            String sql= "select t.TABLE_NAME,t1.COMMENTS from user_TABLES t,user_tab_comments t1 where t.table_name=t1.table_name  order by t.table_name";
            System.out.println(sql);
            ResultSet rsTables = stmt.executeQuery(sql);
            while (rsTables.next()){
                try {
                    String tableName = rsTables.getString("TABLE_NAME");//表名
                    String tableAlias = initString(rsTables.getString("COMMENTS"));//表注释

                    if (StringUtils.startsWith(tableName,"C")){
                        break;
                    }
                    TableData tableData = initTableData(tableName,tableAlias);
                    tableDataList.add(tableData);
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
            System.out.println(JSON.toJSONString(tableDataList));
            if (createXml){
                initList2Xml(tableDataList);
            }
            initList2Entity(tableDataList);
        }catch (Exception e){
            e.printStackTrace();
        }finally{
            con.close();
        }
    }

    public static void createEntityOrXmlByTableMap(boolean createXml,HashMap<String,String> tableMap) throws SQLException{
        List<TableData> tableDataList = new ArrayList<TableData>();
        try {
            getConnection();
            for (Map.Entry<String,String> entry : tableMap.entrySet()) {
                String tableName = entry.getKey();//表名
                String tableAlias = initString(entry.getValue());//表注释

                TableData tableData = initTableData(tableName,tableAlias);
                tableDataList.add(tableData);
                System.out.println(JSON.toJSONString(tableDataList));
            }

            if (createXml){
                initList2Xml(tableDataList);
            }
            initList2Entity(tableDataList);
        }catch (Exception e){
            e.printStackTrace();
        }finally{
            con.close();
        }
    }

    public static TableData initTableData(String tableName,String tableAlias){
        TableData tableData = new TableData();
        try {
            tableData.setDATANAME(tableName);
            tableData.setCOMMENTS(tableAlias);
            tableData.setVO_NAME(packagePath+"."+getLowerTableName(tableName,true));

            List<TableField> fieldList = new ArrayList<TableField>();

            String fieldsql = " select a.TABLE_NAME,a.COLUMN_NAME,b.comments,a.DATA_LENGTH,a.DATA_TYPE,a.DATA_PRECISION,a.DATA_SCALE, " +
                    "decode(c.column_name,null,'N','Y') as PRIMARY,a.NULLABLE " +
                    "from all_tab_columns a  " +
                    "left join all_col_comments b on a.Table_Name=b.table_Name and a.column_name=b.column_name " +
                    "left join  " +
                    "( " +
                    "select a.constraint_name, a.column_name " +
                    "from user_cons_columns a, user_constraints b " +
                    "where a.constraint_name = b.constraint_name " +
                    "     and b.constraint_type = 'P' " +
                    "     and a.table_name = '"+tableName+"' " +
                    ") c on c.column_name=a.column_name " +
                    " where  " +
                    "  a.Table_Name='"+tableName+"' " +
                    " and a.owner=b.owner  " +
                    " and a.owner='"+DATABASE_USER.toUpperCase()+"'" +
                    " order by a.COLUMN_ID";
            System.out.println(fieldsql);
            Statement fieldstmt = con.createStatement();
            ResultSet rs = fieldstmt.executeQuery(fieldsql);
            while (rs.next()){
                //<COLUMN COLUMN_NAME="PB_ID" COMMENTS="" ISPK="Y" LENGTH="32" NULLABLE="Y" PRECISION="0" SCALE="0" TYPE="VARCHAR2"/>
                TableField tableField = new TableField();
                tableField.setCOLUMN_NAME(rs.getString("COLUMN_NAME"));
                tableField.setCOMMENTS(initString(rs.getString("COMMENTS")));

                tableField.setISPK(rs.getString("PRIMARY"));

                tableField.setLENGTH(rs.getString("DATA_LENGTH"));
                tableField.setPRECISION(rs.getString("DATA_PRECISION"));
                tableField.setSCALE(rs.getString("DATA_SCALE"));
                tableField.setNULLABLE(rs.getString("NULLABLE"));
                tableField.setTYPE(rs.getString("DATA_TYPE"));
                if (StringUtils.equalsIgnoreCase(tableField.getTYPE(),"VARCHAR2") && StringUtils.equalsIgnoreCase(tableField.getISPK(),"N")){
                    if (StringUtils.isNotBlank(tableField.getLENGTH())){
                        Integer length = Integer.parseInt(tableField.getLENGTH());
                        if (length<2000){
                            tableField.setLENGTH(String.valueOf(length*2));
                        }
                    }
                }
                fieldList.add(tableField);
            }
            tableData.setFieldList(fieldList);
            System.out.println(tableName);
        }catch (Exception e){}
        return tableData;
    }

    public static void initList2Xml(List<TableData> tableDataList){
        Document document = DocumentHelper.createDocument();
        Element rootEle = DocumentHelper.createElement("REPORT");
        rootEle.addAttribute("FRNAME","建设用地报件交换格式");
        rootEle.addAttribute("PATH","/");
        rootEle.addAttribute("REPORTNAME","");
        rootEle.addAttribute("VERSION","7.0");
        document.setRootElement(rootEle);

        if (tableDataList != null && !tableDataList.isEmpty()){
            for (int i = 0; i < tableDataList.size(); i++) {
                try {
                    TableData tableData = tableDataList.get(i);
                    Element dataEle = DocumentHelper.createElement("DATA");

                    Class objClass = TableData.class;
                    Field[] fields = objClass.getDeclaredFields();
                    for (int j = 0; j < fields.length; j++) {
                        Field field = fields[j];
                        if (StringUtils.equalsIgnoreCase(field.getName(),"fieldList")){
                            continue;
                        }
                        Method method = objClass.getDeclaredMethod("get"+field.getName());
                        Object objvalue = method.invoke(tableData);
                        dataEle.addAttribute(field.getName(),objvalue==null?"":objvalue.toString());
                    }

                    Element fieldEle = DocumentHelper.createElement("FIELDS");
                    List<TableField> fieldList = tableData.getFieldList();
                    if (fieldList != null && !fieldList.isEmpty()){
                        for (int j = 0; j < fieldList.size(); j++) {
                            TableField tableField = fieldList.get(j);
                            Element columnEle = DocumentHelper.createElement("COLUMN");

                            Class fieldClass = TableField.class;
                            Field[] fieldFields = fieldClass.getDeclaredFields();
                            for (int k = 0; k < fieldFields.length; k++) {
                                Field field = fieldFields[k];
                                Method method = fieldClass.getDeclaredMethod("get"+field.getName());
                                Object objvalue = method.invoke(tableField);
                                columnEle.addAttribute(field.getName(),objvalue==null?"":objvalue.toString());
                            }
                            fieldEle.add(columnEle);
                        }
                    }
                    dataEle.add(fieldEle);

                    Element rowEle = DocumentHelper.createElement("ROWDATA");
                    String sql = "select t.* from " + tableData.getDATANAME();
                    Statement fieldstmt = con.createStatement();
                    ResultSet rs = fieldstmt.executeQuery(sql);
                    while (rs.next()) {
                        for (int j = 0; j < fieldList.size(); j++) {
                            TableField tableField = fieldList.get(j);
                            String value = rs.getString(tableField.getCOLUMN_NAME());
                            if (StringUtils.isBlank(value)){
                                value = "";
                            }
                            rowEle.addAttribute(tableField.getCOLUMN_NAME(),value);
                        }
                    }

                    dataEle.add(rowEle);

                    rootEle.add(dataEle);
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }
        System.out.println(document.asXML());

    }

    public static void initList2Entity(List<TableData> tableDataList){
        if (tableDataList != null && !tableDataList.isEmpty()){
            for (int i = 0; i < tableDataList.size(); i++) {
                try {
                    TableData tableData = tableDataList.get(i);

                    String entityName = StringUtils.replace(tableData.getVO_NAME(),packagePath+".","");
                    StringBuffer javaContentBuffer = new StringBuffer();
                    javaContentBuffer.append("package "+packagePath+";\n");
                    javaContentBuffer.append("\n");

                    javaContentBuffer.append("import javax.persistence.Id;\n");
                    javaContentBuffer.append("import javax.persistence.Table;\n");
                    javaContentBuffer.append("import java.io.Serializable;\n");
                    javaContentBuffer.append("import java.math.BigDecimal;\n");
                    javaContentBuffer.append("import java.util.Date;\n");
                    javaContentBuffer.append("\n");

                    javaContentBuffer.append("/**\n");
                    javaContentBuffer.append(" * "+tableData.getCOMMENTS()+"\n");
                    javaContentBuffer.append(" */\n");
                    javaContentBuffer.append("@Table(name = \""+tableData.getDATANAME()+"\")\n");
                    javaContentBuffer.append("public class "+entityName+" implements Serializable {\n");

                    StringBuffer javaFunctionBuffer = new StringBuffer();
                    //entityName

                    List<TableField> fieldList = tableData.getFieldList();
                    if (fieldList != null && !fieldList.isEmpty()){
                        for (int j = 0; j < fieldList.size(); j++) {
                            TableField tableField = fieldList.get(j);

                            if (StringUtils.equalsIgnoreCase(tableField.getISPK(),"Y")){
                                javaContentBuffer.append("    @Id\n");
                            }
                            String fieldType = fieldTypeMap.get(tableField.getTYPE());
                            if (StringUtils.equalsIgnoreCase(tableField.getTYPE(),"NUMBER") && (StringUtils.equalsIgnoreCase(tableField.getSCALE(),"0") || StringUtils.isBlank(tableField.getSCALE()))){
                                fieldType = fieldTypeMap.get("INTEGER");
                            }
                            //处理下划线，将下划线后第一个字母改为大写字母
                            String lowerColumnName = getLowerColumnName(tableField.getCOLUMN_NAME(),true);

                            javaContentBuffer.append("    private "+fieldType+" "+lowerColumnName+";");
                            if (StringUtils.isNotBlank(tableField.getCOMMENTS())){
                                javaContentBuffer.append("//"+tableField.getCOMMENTS());
                            }
                            javaContentBuffer.append("\n\n");

                            String method = getLowerColumnName(tableField.getCOLUMN_NAME(),false);
                            String functionName = tableField.getCOLUMN_NAME().substring(0,1)+lowerColumnName.substring(1,lowerColumnName.length());

                            javaFunctionBuffer.append("    public "+fieldType+" get"+functionName+"() {\n");
                            javaFunctionBuffer.append("        return "+lowerColumnName+";\n");
                            javaFunctionBuffer.append("    }\n");
                            javaFunctionBuffer.append("\n");

                            javaFunctionBuffer.append("    public void set"+functionName+"("+fieldType+" "+lowerColumnName+") {\n");
                            javaFunctionBuffer.append("        this."+lowerColumnName+" = "+lowerColumnName+";\n");
                            javaFunctionBuffer.append("    }\r\n");
                            javaFunctionBuffer.append("\n");
                        }
                    }

                    javaContentBuffer.append(javaFunctionBuffer);
                    javaContentBuffer.append("}");

                    System.out.println(javaContentBuffer.toString());
                    String filePath = entityPath+entityName+".java";
                    createFiles(filePath);
                    FileOutputStream fileOutputStream = new FileOutputStream(filePath);
                    fileOutputStream.write(javaContentBuffer.toString().getBytes("UTF-8"));
                    fileOutputStream.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }

                try {
                    TableData tableData = tableDataList.get(i);

                    String entityName = StringUtils.replace(tableData.getVO_NAME(),packagePath+".","");
                    StringBuffer javaContentBuffer = new StringBuffer();
                    javaContentBuffer.append("package "+packagePath+";\n");
                    javaContentBuffer.append("\n");

                    javaContentBuffer.append("import cn.gtmap.common.core.support.mybatis.mapper.Example;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.model.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.impl.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.impl.*;\n");
                    javaContentBuffer.append("import com.alibaba.fastjson.JSON;\n");
                    javaContentBuffer.append("import org.apache.commons.lang.StringUtils;\n");
                    javaContentBuffer.append("import org.springframework.data.domain.Pageable;\n");
                    javaContentBuffer.append("import org.springframework.stereotype.Component;\n");
                    javaContentBuffer.append("import java.util.*;\n");
                    javaContentBuffer.append("\n");

                    javaContentBuffer.append("/**\n");
                    javaContentBuffer.append(" * "+tableData.getCOMMENTS()+"\n");
                    javaContentBuffer.append(" */\n");
                    javaContentBuffer.append("public interface "+entityName+"Service  extends BaseService<"+entityName+", String> {\n");

                    javaContentBuffer.append("}");
                    //@Component
                    //public class TDemoServiceImpl extends BaseServiceImpl<TDemo, String> implements TDemoService

                    System.out.println(javaContentBuffer.toString());
                    String filePath = entityPath+entityName+"Service.java";
                    createFiles(filePath);
                    FileOutputStream fileOutputStream = new FileOutputStream(filePath);
                    fileOutputStream.write(javaContentBuffer.toString().getBytes("UTF-8"));
                    fileOutputStream.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    TableData tableData = tableDataList.get(i);

                    String entityName = StringUtils.replace(tableData.getVO_NAME(),packagePath+".","");
                    StringBuffer javaContentBuffer = new StringBuffer();
                    //javaContentBuffer.append("package "+packagePath+";\n");
                    javaContentBuffer.append("package cn.gtmap.busi.service.impl;\n");
                    javaContentBuffer.append("\n");

                    javaContentBuffer.append("import cn.gtmap.common.core.support.mybatis.mapper.Example;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.model.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.impl.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.impl.*;\n");
                    javaContentBuffer.append("import com.alibaba.fastjson.JSON;\n");
                    javaContentBuffer.append("import org.apache.commons.lang.StringUtils;\n");
                    javaContentBuffer.append("import org.springframework.data.domain.Pageable;\n");
                    javaContentBuffer.append("import org.springframework.stereotype.Component;\n");
                    javaContentBuffer.append("import java.util.*;\n");
                    javaContentBuffer.append("\n");

                    javaContentBuffer.append("/**\n");
                    javaContentBuffer.append(" * "+tableData.getCOMMENTS()+"\n");
                    javaContentBuffer.append(" */\n");
                    javaContentBuffer.append("@Component\n");
                    javaContentBuffer.append("public class "+entityName+"ServiceImpl extends BaseServiceImpl<"+entityName+", String> implements "+entityName+"Service {\n");

                    javaContentBuffer.append("}");

                    System.out.println(javaContentBuffer.toString());
                    String filePath = entityPath+entityName+"ServiceImpl.java";
                    createFiles(filePath);
                    FileOutputStream fileOutputStream = new FileOutputStream(filePath);
                    fileOutputStream.write(javaContentBuffer.toString().getBytes("UTF-8"));
                    fileOutputStream.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String initString(String comments){
        if (StringUtils.isBlank(comments)){
            comments = "";
        }
        comments = StringUtils.replace(comments," ","");
        comments = StringUtils.replace(comments,"　","");
        comments = StringUtils.replace(comments,"\n","");
        comments = StringUtils.replace(comments,"\r","");
        return comments;
    }

    /**
     * 处理下划线，去掉匹配字符串
     * @param upperColumnName
     * @param isRemoveTS 是否去掉“T_”、“S_”开头字符串
     * @return
     */
    public static String getLowerTableName(String upperColumnName, boolean isRemoveTS){
        if (isRemoveTS) {
            if (upperColumnName.startsWith("T_")) {
                upperColumnName = upperColumnName.replaceFirst("T_", "");
            }
            if (upperColumnName.startsWith("S_")) {
                upperColumnName = upperColumnName.replaceFirst("S_", "");
            }
            if (upperColumnName.startsWith("SB_")) {
                upperColumnName = upperColumnName.replaceFirst("SB_", "");
            }
        }
        String lowerColumnName = upperColumnName.toLowerCase();
        //处理下划线，将下划线后第一个字母改为大写字母，并去除下划线
        if (upperColumnName.indexOf("_") > -1) {
            lowerColumnName = "";
            //tableField.getCOLUMN_NAME().substring(0,1)+lowerColumnName.substring(1,lowerColumnName.length());
            String[] _Arrays = upperColumnName.substring(1,upperColumnName.length()).split("_");
            lowerColumnName += upperColumnName.substring(0,1);
            lowerColumnName += _Arrays[0].toLowerCase();
            for (int i = 1; i < _Arrays.length; i++) {
                lowerColumnName += _Arrays[i].substring(0,1)+_Arrays[i].substring(1,_Arrays[i].length()).toLowerCase();
            }
        }
        return lowerColumnName;
    }

    /**
     * 处理下划线，将下划线后第一个字母改为大写字母
     * @param upperColumnName
     * @param isRemove_ 是否处理下划线
     * @return
     */
    public static String getLowerColumnName(String upperColumnName, boolean isRemove_){
        String lowerColumnName = upperColumnName.toLowerCase();
        if (isRemove_) {
            //处理下划线，将下划线后第一个字母改为大写字母，并去除下划线
            if (upperColumnName.indexOf("_") > -1) {
                lowerColumnName = "";
                String[] _Arrays = upperColumnName.split("_");
                lowerColumnName += _Arrays[0].toLowerCase();
                for (int i = 1; i < _Arrays.length; i++) {
                    lowerColumnName += _Arrays[i].substring(0,1)+_Arrays[i].substring(1,_Arrays[i].length()).toLowerCase();
                }
            }
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        return lowerColumnName;
    }

    public static HashMap<String,String> initFieldTypeMap(){
        HashMap<String,String> fieldTypeMap = new HashMap<String,String>();
        fieldTypeMap.put("VARCHAR2","String");
        fieldTypeMap.put("DATE","Date");
        fieldTypeMap.put("NUMBER","BigDecimal");
        fieldTypeMap.put("FLOAT","BigDecimal");
        fieldTypeMap.put("CLOB","byte[]");
        fieldTypeMap.put("INTEGER","Integer");
        fieldTypeMap.put("CHAR","String");
        fieldTypeMap.put("TIMESTAMP(6)","Date");
        return fieldTypeMap;
    }

    /**
     * 非根路径中创建文件，即多层文件夹是 前提是: path必须一个正确的路径 拷贝单个文件
     *
     * @param path 文件
     */
    public static Boolean createFiles(String path) {
        Boolean flag = false;
        File file = null;
        if (!path.equals("") || path != null) {
            file = new File(path);
            if (!file.exists()) {
                if (file.isDirectory()) {
                    file.mkdirs();
                }else {
                    // 创建目录
                    File fileDir = new File(file.getParent());
                    fileDir.mkdirs();
                    System.out.println("上层文件夹： " + fileDir);
                    try {
                        flag = file.createNewFile();// 在已有文件路径上直接创建文件
                        System.out.println("文件名称：" + file);
                    } catch (IOException e) {
                        System.out.println("创建文件失败：" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("【" + path + "】：" + "该文件已经存在");
            }
        }
        return flag;
    }
}


