package cn.gtmap.common.utils;

import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

/**
 * @文件说明
 * @作者 deery
 * @创建日期 15:23
 * @版本号 V 1.0
 * 该方法的应用场景是放在单元测试或者独立的测试类中，用于引用spirng中配置的httpinvoker的bean，来实例化
 * 使用方法：
String fileCenterUrl = "http://127.0.0.1:8090/fileCenter";
NodeService nodeService = new HttpInvokerProxyFactory<NodeService>().getProxy(fileCenterUrl+"/http/nodeService",NodeService.class);
FileServiceImpl fileService = new FileServiceImpl();
fileService.setFileCenterUrl(fileCenterUrl);
fileService.setNodeService(nodeService);
 */
public class HttpInvokerProxyFactory<O extends Object>  {
    public O getProxy(String serviceUrl,Class cls) {

        HttpInvokerProxyFactoryBean httpInvokerProxyFactoryBean = new HttpInvokerProxyFactoryBean();

        httpInvokerProxyFactoryBean.setServiceInterface(cls);

        httpInvokerProxyFactoryBean.setServiceUrl(serviceUrl);

        httpInvokerProxyFactoryBean.afterPropertiesSet();

        return (O) httpInvokerProxyFactoryBean.getObject();
    }
}
