package cn.gtmap.common.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import cn.gtmap.common.OracleOpera.TableData;
import cn.gtmap.common.OracleOpera.TableField;

/***
 *  生成oracle数据库更新文件<br>
 *  <br>
 *  GenerateSqlUtil.DATABASE_URL = "jdbc:oracle:thin:@10.5.0.176:1521:szgt";<br>
 *  GenerateSqlUtil.DATABASE_USER = "gtis_bl";<br>
 *  GenerateSqlUtil.DATABASE_PASSWORD = "gtis";<br>
 *  GenerateSqlUtil.filePath = "d:/gtis_bl.sql";<br>
 *  List<String> tableNameList = new ArrayList<String>();<br>
 *  tableNameList.add("BL_APPSUBAREA");<br>
 *  GenerateSqlUtil.tableNameList = tableNameList;<br>
 *  GenerateSqlUtil.createSqlFile();<br>
 *  <br>
 *  select 'tableNameList.add("'||table_name||'");' from user_tables order by table_name
 */
public class GenerateSqlUtil {
    /**
     * 数据库驱动地址
     */
    private static String DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    /**
     * 数据库连接参数
     */
    public static String DATABASE_URL = "jdbc:oracle:thin:@10.5.0.176:1521:szgt";
    /**
     * 数据库用户名
     */
    public static String DATABASE_USER = "gtis_bl";
    /**
     * 数据库密码
     */
    public static String DATABASE_PASSWORD = "gtis";
	/**
	 * 创建路径
	 */
    public static String filePath = "d:/gtis_bl.sql";
    /**
     * 表名
     */
    public static List<String> tableNameList;
    private static Connection con = null;

    private static Connection getConnection() {
        try {
            Class.forName(DRIVER_CLASS);
            con = DriverManager.getConnection(DATABASE_URL,DATABASE_USER,DATABASE_PASSWORD);
            return con;
        } catch (Exception ex) {
            System.out.println("2:"+ex.getMessage());
        }
        return con;
    }
    
    public static void main(String[] args) throws Exception {
    	createSqlFile();
    }
    
    public static void createSqlFile() throws Exception {
    	List<TableData> tableDataList = getTableDataList();
    	if (CollectionUtils.isNotEmpty(tableDataList)) {
    		createFiles(filePath);
    		File file = new File(filePath);
    		BufferedWriter output = new BufferedWriter(new FileWriter(file));
    		try {
    			output.write("declare tableExist number;");
    			output.newLine();
    			output.write("begin");
    			output.newLine();
    			output.newLine();
				for (TableData tableData : tableDataList) {
					output.write("select count(1) into tableExist from user_tables where table_name='"+tableData.getDATANAME()+"';");
					output.newLine();
					output.write("if tableExist=0 then");
					output.newLine();
					output.write("execute immediate");
					output.newLine();
					output.write("'CREATE TABLE "+tableData.getDATANAME()+"(");
					output.newLine();
					List<TableField> fieldList = tableData.getFieldList();
					if (CollectionUtils.isNotEmpty(fieldList)) {
						for (int i = 0; i < fieldList.size(); i++) {
							TableField tableField = fieldList.get(i);
							String tmp = tableField.getCOLUMN_NAME()+" ";
							if ("NUMBER".equals(tableField.getTYPE()) && StringUtils.isBlank(tableField.getPRECISION())) {
								tmp += "INTEGER";
							} else {
								tmp += tableField.getTYPE();
							}
							if ("VARCHAR2".equals(tableField.getTYPE())) {
								tmp += "("+tableField.getLENGTH()+")";
							} else if ("NUMBER".equals(tableField.getTYPE())) {
								if (StringUtils.isNotBlank(tableField.getPRECISION())) {
									if ("0".equals(tableField.getSCALE())) {
										tmp += "("+tableField.getPRECISION()+")";
									} else {
										tmp += "("+tableField.getPRECISION()+","+tableField.getSCALE()+")";
									}
								}
							}
							if ("N".equals(tableField.getNULLABLE())) {
								tmp += " not null";
							}
							if (StringUtils.isNotBlank(tableField.getDEFAULT())) {
								if (StringUtils.contains(tableField.getDEFAULT(), "'")) {
									tmp += " default '" + tableField.getDEFAULT() + "'";
								} else {
									tmp += " default " + tableField.getDEFAULT() + "";
								}
							}
							if (i < fieldList.size() - 1) {
								tmp += ",";
							}
							output.write(tmp);
							output.newLine();
						}
					}
					output.write(")';");
					output.newLine();
					if (CollectionUtils.isNotEmpty(fieldList)) {
						for (int i = 0; i < fieldList.size(); i++) {
							TableField tableField = fieldList.get(i);
							if (StringUtils.isNotBlank(tableField.getCOMMENTS())) {
								output.write("execute immediate");
								output.newLine();
								output.write("'comment on column "+tableData.getDATANAME()+"."+tableField.getCOLUMN_NAME()+" is ''"+tableField.getCOMMENTS()+"''';");
								output.newLine();
							}
							if ("Y".equals(tableField.getISPK())) {
								output.write("execute immediate");
								output.newLine();
								output.write("'alter table "+tableData.getDATANAME()+" add constraint PK_"+tableData.getDATANAME()+"_ID primary key ("+tableField.getCOLUMN_NAME()+")';");
								output.newLine();
							}
						}
					}
					output.write("else");
					output.newLine();
					if (CollectionUtils.isNotEmpty(fieldList)) {
						output.write("declare columnExist number;");
		    			output.newLine();
						output.write("begin");
		    			output.newLine();
						for (int i = 0; i < fieldList.size(); i++) {
							TableField tableField = fieldList.get(i);
							output.write("select count(1) into columnExist from user_tab_cols where table_name='"+tableData.getDATANAME()+"' and column_name='"+tableField.getCOLUMN_NAME()+"';");
							output.newLine();
							output.write("if columnExist=0 then");
							output.newLine();
							output.write("execute immediate");
							output.newLine();
							String tmp = "'ALTER TABLE "+tableData.getDATANAME()+" ADD "+tableField.getCOLUMN_NAME()+" ";
							if ("NUMBER".equals(tableField.getTYPE()) && StringUtils.isBlank(tableField.getPRECISION())) {
								tmp += "INTEGER";
							} else {
								tmp += tableField.getTYPE();
							}
							if ("VARCHAR2".equals(tableField.getTYPE())) {
								tmp += "("+tableField.getLENGTH()+")";
							} else if ("NUMBER".equals(tableField.getTYPE())) {
								if (StringUtils.isNotBlank(tableField.getPRECISION())) {
									if ("0".equals(tableField.getSCALE())) {
										tmp += "("+tableField.getPRECISION()+")";
									} else {
										tmp += "("+tableField.getPRECISION()+","+tableField.getSCALE()+")";
									}
								}
							}
							if ("N".equals(tableField.getNULLABLE())) {
								tmp += " not null";
							}
							if (StringUtils.isNotBlank(tableField.getDEFAULT())) {
								if (StringUtils.contains(tableField.getDEFAULT(), "'")) {
									tmp += " default '" + tableField.getDEFAULT() + "'";
								} else {
									tmp += " default " + tableField.getDEFAULT() + "";
								}
							}
							tmp += "';";
							output.write(tmp);
							output.newLine();
							output.write("execute immediate");
							output.newLine();
							output.write("'comment on column "+tableData.getDATANAME()+"."+tableField.getCOLUMN_NAME()+" is ''"+tableField.getCOMMENTS()+"''';");
							output.newLine();
							if ("Y".equals(tableField.getISPK())) {
								output.write("execute immediate");
								output.newLine();
								output.write("'alter table "+tableData.getDATANAME()+" add constraint PK_"+tableData.getDATANAME()+"_ID primary key ("+tableField.getCOLUMN_NAME()+")';");
								output.newLine();
							}
							output.write("end if;");
							output.newLine();
						}
						output.write("end;");
		    			output.newLine();
					}
					output.write("end if;");
					output.newLine();
	    			output.newLine();
				}
				output.write("end;");
				output.newLine();
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				output.close();
			}
		}
    }

    private static List<TableData> getTableDataList() throws Exception {
    	List<TableData> tableDataList = new ArrayList<TableData>();
    	try {
            getConnection();
            
            if (CollectionUtils.isEmpty(tableNameList)) {
            	//获取所有数据库表
                Statement stmt = con.createStatement();
                String sql = "select t.TABLE_NAME,t1.COMMENTS from user_TABLES t,user_tab_comments t1 where t.table_name=t1.table_name order by t.table_name";
                ResultSet rsTables = stmt.executeQuery(sql);
                while (rsTables.next()){
                    try {
                        String tableName = rsTables.getString("TABLE_NAME");//表名
                        String tableAlias = initString(rsTables.getString("COMMENTS"));//表注释

                        TableData tableData = initTableData(tableName,tableAlias);
                        tableDataList.add(tableData);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
			} else {
				for (String tableName : tableNameList) {
					Statement stmt = con.createStatement();
	                String sql = "select t.comments from user_tab_comments t where t.table_name='"+StringUtils.upperCase(tableName)+"'";
	                ResultSet rsTables = stmt.executeQuery(sql);
	                while (rsTables.next()){
	                    try {
	                        String tableAlias = initString(rsTables.getString("COMMENTS"));//表注释
	                        TableData tableData = initTableData(tableName,tableAlias);
	                        tableDataList.add(tableData);
	                    }catch (Exception e){
	                        e.printStackTrace();
	                    }
	                }
				}
			}
        }catch (Exception e){
            e.printStackTrace();
        }finally{
            con.close();
        }
        return tableDataList;
    }

    private static TableData initTableData(String tableName,String tableAlias){
        TableData tableData = new TableData();
        try {
            tableData.setDATANAME(tableName);
            tableData.setCOMMENTS(tableAlias);

            List<TableField> fieldList = new ArrayList<TableField>();

            String fieldsql = " select a.TABLE_NAME,a.COLUMN_NAME,b.comments,a.DATA_LENGTH,a.DATA_TYPE,a.DATA_PRECISION,a.DATA_SCALE, " +
                    "decode(c.column_name,null,'N','Y') as PRIMARY,a.NULLABLE,a.DATA_DEFAULT " +
                    "from all_tab_columns a  " +
                    "left join all_col_comments b on a.Table_Name=b.table_Name and a.column_name=b.column_name " +
                    "left join  " +
                    "( " +
                    "select a.constraint_name, a.column_name " +
                    "from user_cons_columns a, user_constraints b " +
                    "where a.constraint_name = b.constraint_name " +
                    "     and b.constraint_type = 'P' " +
                    "     and a.table_name = '"+tableName+"' " +
                    ") c on c.column_name=a.column_name " +
                    " where  " +
                    "  a.Table_Name='"+tableName+"' " +
                    " and a.owner=b.owner  " +
                    " and a.owner='"+DATABASE_USER.toUpperCase()+"'" +
                    " order by a.COLUMN_ID";
            Statement fieldstmt = con.createStatement();
            ResultSet rs = fieldstmt.executeQuery(fieldsql);
            while (rs.next()){
                //<COLUMN COLUMN_NAME="PB_ID" COMMENTS="" ISPK="Y" LENGTH="32" NULLABLE="Y" PRECISION="0" SCALE="0" TYPE="VARCHAR2"/>
                TableField tableField = new TableField();
                tableField.setCOLUMN_NAME(rs.getString("COLUMN_NAME"));
                tableField.setCOMMENTS(initString(rs.getString("COMMENTS")));

                tableField.setISPK(rs.getString("PRIMARY"));

                tableField.setLENGTH(rs.getString("DATA_LENGTH"));
                tableField.setPRECISION(rs.getString("DATA_PRECISION"));
                tableField.setSCALE(rs.getString("DATA_SCALE"));
                tableField.setNULLABLE(rs.getString("NULLABLE"));
                tableField.setTYPE(rs.getString("DATA_TYPE"));
                tableField.setDEFAULT(rs.getString("DATA_DEFAULT"));
                fieldList.add(tableField);
            }
            tableData.setFieldList(fieldList);
        }catch (Exception e){}
        return tableData;
    }

    private static String initString(String comments){
        if (StringUtils.isBlank(comments)){
            comments = "";
        }
        comments = StringUtils.replace(comments," ","");
        comments = StringUtils.replace(comments,"　","");
        comments = StringUtils.replace(comments,"\n","");
        comments = StringUtils.replace(comments,"\r","");
        return comments;
    }

    /**
     * 非根路径中创建文件，即多层文件夹是 前提是: path必须一个正确的路径 拷贝单个文件
     *
     * @param path 文件
     */
    private static Boolean createFiles(String path) {
        Boolean flag = false;
        File file = null;
        if (!path.equals("") || path != null) {
            file = new File(path);
            if (!file.exists()) {
                if (file.isDirectory()) {
                    file.mkdirs();
                }else {
                    // 创建目录
                    File fileDir = new File(file.getParent());
                    fileDir.mkdirs();
                    System.out.println("上层文件夹： " + fileDir);
                    try {
                        flag = file.createNewFile();// 在已有文件路径上直接创建文件
                        System.out.println("文件名称：" + file);
                    } catch (IOException e) {
                        System.out.println("创建文件失败：" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        return flag;
    }
}
