package cn.gtmap.common.service.impl;

import cn.gtmap.common.core.support.mybatis.mapper.Example;
import cn.gtmap.common.model.SignOpinionConfigEntity;
import cn.gtmap.common.service.SignService;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2016/3/5
 */
public class SignServiceImpl extends BaseServiceImpl<SignOpinionConfigEntity, String> implements SignService {
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 政务平台签名服务
     */
    private SysSignService sysSignService;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 政务平台任务服务
     */
    private SysTaskService sysTaskService;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 政务平台工作流实例服务
     */
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;

    private SysUserService sysUserServiceImpl;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 签名map
     */
    private Map<String,String> signKeyMap;

    public SysSignService getSysSignService() {
        return sysSignService;
    }

    public void setSysSignService(SysSignService sysSignService) {
        this.sysSignService = sysSignService;
    }

    public SysTaskService getSysTaskService() {
        return sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return sysWorkFlowInstanceService;
    }

    public SysUserService getSysUserServiceImpl() {
        return sysUserServiceImpl;
    }

    public void setSysUserServiceImpl(SysUserService sysUserServiceImpl) {
        this.sysUserServiceImpl = sysUserServiceImpl;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public Map<String, String> getSignKeyMap() {
        return signKeyMap;
    }

    public void setSignKeyMap(Map<String, String> signKeyMap) {
        this.signKeyMap = signKeyMap;
    }

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param proid 项目ID
     * @param userid 用户ID
     * @param activityid 当前活动ID
     * @param targetActivityDefids 目标活动定义ID
     * @return
     * @description 针对工作流活动取回或退回的签名意见处理
     */
    @Override
    public void handleRetreatSign(String proid, String userid, String activityid, String targetActivityDefids) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
        PfActivityVo backActivitys =null;
        if(pfWorkFlowInstanceVo!=null){
            backActivitys = sysTaskService.getActivityBywIdandadId(pfWorkFlowInstanceVo.getWorkflowIntanceId(), targetActivityDefids);
        }
        if(backActivitys!=null && StringUtils.isNotBlank(backActivitys.getActivityName())){
            if(signKeyMap.containsKey(backActivitys.getActivityName())){
                String signKey = signKeyMap.get(backActivitys.getActivityName());
                deleleSign(proid,signKey);
            }
        }
    }

    /**
     * @author <a href="mailto:xuchao@gtmap.cn">xuchao</a>
     * @param proid 项目ID
     * @return
     * @description 针对工作流活动转发，根据配置签名userid,和key ，并自动签名
     */
    @Override
    public String handleTurnAutoSignBySignkeys(String proid,String userid) {
        String str = "";
        //获取需要自动签名的Userid
        String autoSignUserId = AppConfig.getProperty("sign.auto.user");
        //获取需要自动签名的signkey,多个值","隔开
        String autoSignKey = AppConfig.getProperty("sign.auto.key");
        if(StringUtils.isNotBlank(autoSignUserId) && StringUtils.isNotBlank(autoSignKey)){
            String[] autoSignUserIdArr = autoSignUserId.split(",");
            //因为最后一个是“，”分割后会少一个，所以判断如果最后一个字符是",",则给autoSignUserIdArr添加一个空值
            if(autoSignUserId.endsWith(",")){
                autoSignUserIdArr = Arrays.copyOf(autoSignUserIdArr, autoSignUserIdArr.length + 1);//数组扩容
                autoSignUserIdArr[autoSignUserIdArr.length-1] = "";
            }
            String[] autoSignKeyArr = autoSignKey.split(",");
            //判断如果autoSignUserIdArr.length != autoSignKeyArr.length，不允许转发，配置错误
            if(autoSignUserIdArr.length!=autoSignKeyArr.length){
                str =  "请检查配置文件，sign.auto.user、sign.auto.key两个值无法匹配！";
            }else{
                for(int i=0;i<autoSignKeyArr.length;i++){
                    String tempUserId = autoSignUserIdArr[i];
                    String tempSignKey = autoSignKeyArr[i];
                    //判断是否已经签名
                    List<PfSignVo> pfSignVoList = sysSignService.getSignList(tempSignKey, proid);
                    if(CollectionUtils.isEmpty(pfSignVoList)){
                        //如果tempUserId="",则取当前转发人id
                        if(StringUtils.isBlank(tempUserId)){
                            tempUserId = userid;
                        }
                        //自动签名
                        PfSignVo pfSignVo= initPfSignVo(proid,tempSignKey,tempUserId);
                        sysSignService.insertAutoSign(pfSignVo);
                    }
                }
            }
        }
        return str;
    }

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param proid 项目ID
     * @param signKey 签名key，多个key以逗号隔开
     * @return
     * @description 根据签名key删除项目的某些签名
     */
    private void deleleSign(String proid,String signKey){
        String signKeysArr[]  = signKey.split(",");
        for (String tmpSignKey:signKeysArr){
            List<PfSignVo> pfSignVoList = sysSignService.getSignList(tmpSignKey, proid);
            if(CollectionUtils.isNotEmpty(pfSignVoList)){
                for(PfSignVo pfSignVo:pfSignVoList){
                    sysSignService.deleteSign(pfSignVo.getSignId());
                }
            }
        }
    }

    private PfSignVo initPfSignVo(String proid,String signkey,String singUserid){
        PfSignVo pfSignVo = new PfSignVo();
        pfSignVo.setProId(proid);
        pfSignVo.setSignKey(signkey);
        pfSignVo.setSignId(UUIDGenerator.generate());
        pfSignVo.setSignOpinion("");//目前设置为空，可读取配置
        pfSignVo.setSignType("1");
        pfSignVo.setUserId(singUserid);
        pfSignVo.setSignName(sysUserServiceImpl.getUserVo(singUserid).getUserName());
        pfSignVo.setSignDate(Calendar.getInstance().getTime());
        return pfSignVo;
    }

    public List<SignOpinionConfigEntity> getSignOpinionListByWf(String opinionType,String userId,String activityName,String isrightclick,String isuse){
        List<SignOpinionConfigEntity> lstOpinions = null;
        Example excmple = new Example(SignOpinionConfigEntity.class);
        Example.Criteria criteria = excmple.createCriteria();
        if (StringUtils.isNoneBlank(opinionType)){
            criteria.andEqualTo("workflowname", opinionType);
        }
        if (StringUtils.isNoneBlank(userId)){
            criteria.andEqualTo("userid", userId);
        }
        if (StringUtils.isNoneBlank(activityName)){
            criteria.andEqualTo("activitytype", activityName);
        }
        if (StringUtils.isBlank(isrightclick)){
            isrightclick = "1";
        }
        if (StringUtils.isNoneBlank(isrightclick)){
            criteria.andEqualTo("isrightclick", isrightclick);
        }
        if (StringUtils.isBlank(isuse)){
            isuse = "1";
        }
        if (StringUtils.isNoneBlank(isuse)){
            criteria.andEqualTo("isuse", isuse);
        }
        lstOpinions=entryMapper.selectByExample(SignOpinionConfigEntity.class,excmple);
        return lstOpinions;
    }

}
