package cn.gtmap.common.core.support.xml;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;

/**
 * p
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2015/11/25
 */
public class XmlUtils<T> {
	// 多线程安全的Context.
	private JAXBContext jaxbContext;

	/**
	 * @param types 所有需要序列化的Root对象的类型.
	 */
	public XmlUtils(Class<?>... types) {
		try {
			jaxbContext = JAXBContext.newInstance(types);
		} catch (JAXBException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * xml转换成model
	 * @param t
	 * @return
	 */

	/**
	 * @param object
	 * @return
	 */
	public String entityToXml(Object object) {
		return entityToXml(object, null);
	}

	public String entityToXml(Object object, String encoding) {
		String xmlStr = "";
		try {
			if (object != null) {
				Annotation[] aos = object.getClass().getAnnotations();
				Boolean bol = false;
				for (Annotation ao : aos) {
					if (ao.annotationType().equals(XmlRootElement.class)) {
						bol = true;
						break;
					}
				}
				if (bol) {
					JAXBContext jaxbContext = JAXBContext.newInstance(object.getClass());
					Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
					jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
					if (StringUtils.isNotBlank(encoding))
						jaxbMarshaller.setProperty(Marshaller.JAXB_ENCODING, encoding);
					StringWriter writer = new StringWriter();
					jaxbMarshaller.marshal(object, writer);
					xmlStr = writer.toString();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return xmlStr;
	}

	/**
	 * Xml->Java Object, 支持大小写敏感或不敏感.
	 */
	@SuppressWarnings("unchecked")
	public <T> T fromXml(String xml, boolean caseSensitive) {
		try {
			String fromXml = xml;
			if (!caseSensitive)
				fromXml = xml.toLowerCase();
			StringReader reader = new StringReader(fromXml);
			return (T) createUnmarshaller().unmarshal(reader);
		} catch (JAXBException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 创建UnMarshaller.
	 */
	public Unmarshaller createUnmarshaller() {
		try {
			return jaxbContext.createUnmarshaller();
		} catch (JAXBException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Xml->Java Object.
	 */
	@SuppressWarnings("unchecked")
	public <T> T fromXml(String xml) {
		try {
			StringReader reader = new StringReader(xml);
			return (T) createUnmarshaller().unmarshal(reader);
		} catch (JAXBException e) {
			throw new RuntimeException(e);
		}
	}
}
