/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ConversionService.java
 * Modifier: yangxin
 * Modified: 2014-07-01 21:21
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.common.core.support.spring;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;

import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-1
 */
public class ConversionService extends DefaultConversionService implements InitializingBean {
    private Set<Converter> converters;

    public void setConverters(Set<Converter> converters) {
        this.converters = converters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (converters != null) {
            for (Converter converter : converters) {
                addConverter(converter);
            }
        }
    }
}
