package cn.gtmap.common.core.support.mybatis.page.dialect;

/**
 * Date Created  2014-2-18
 *
 * @author loafer[zjh527@gmail.com]
 * @version 1.0
 */
public abstract class DialectFactory {
    public static Dialect buildDialect(DatabaseDialectShortName databaseName) {
        switch (databaseName) {
            case MYSQL:
                return new MySQLDialect();
            case ORACLE:
                return new OracleDialect();
            case SQLSERVER:
                return new SqlServerDialect();
            default:
                throw new UnsupportedOperationException();
        }
    }
}
