package cn.gtmap.common.core.support.mybatis.mapper;


import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.reflection.MetaObject;

import java.util.*;

/**
 * @author liuzh
 * @author hanxue
 */
public class CommonProvider extends BaseProvider {

    /**
     * 查询，入参可以是Entity.class或new Entity()
     *
     * @param params
     * @return
     */
    public String select(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            SELECT(EntityHelper.getAllColumns(entityClass));
            FROM(entityTable.getName());
            if (entity != null) {
                final MetaObject metaObject = MapperTemplate.forObject(entity);
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) {
                        continue;
                    } else if (column.getJavaType().equals(String.class)) {
                        if (isNotEmpty((String) value)) {
                            WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                        }
                    } else {
                        WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
            StringBuilder orderBy = new StringBuilder();
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                if (column.getOrderBy() != null) {
                    orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy()).append(",");
                }
            }
            if (orderBy.length() > 0) {
                ORDER_BY(orderBy.substring(0, orderBy.length() - 1));
            }
        }}.toString();
    }

    /**
     * 查询，入参可以是Entity.class或new Entity()
     *
     * @param params
     * @return
     */
    public String count(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass;
            if (entity instanceof Class<?>) {
                entityClass = (Class<?>) entity;
                entity = null;
            } else {
                entityClass = getEntityClass(params);
            }
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            SELECT("count(*)");
            FROM(entityTable.getName());
            if (entity != null) {
                MetaObject metaObject = MapperTemplate.forObject(entity);
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) {
                        continue;
                    } else if (column.getJavaType().equals(String.class)) {
                        if (isNotEmpty((String) value)) {
                            WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                        }
                    } else {
                        WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }}.toString();
    }

    /**
     * 通过主键查询，主键字段都不能为空
     *
     * @param params
     * @return
     */
    public String selectByPrimaryKey(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            SELECT(EntityHelper.getAllColumns(entityClass));
            FROM(entityTable.getName());
            if (entityTable.getEntityClassPKColumns().size() == 1) {
                EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                notNullKeyProperty(column.getProperty(), entity);
                WHERE(column.getColumn() + "=#{key}");
            } else {
                MetaObject metaObject = MapperTemplate.forObject(entity);
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    notNullKeyProperty(column.getProperty(), value);
                    WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                }
            }
        }}.toString();
    }


    /**
     * 通过主键查询，主键字段都不能为空
     *
     * @param params
     * @return
     */
    public String selectByForeignKey(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            SELECT(EntityHelper.getAllColumns(entityClass));
            FROM(entityTable.getName());
            if (entityTable.getEntityClassFKColumns().size() == 1) {
                EntityHelper.EntityColumn column = entityTable.getEntityClassFKColumns().iterator().next();
                if (params.get("key") instanceof Map || params.get("key") instanceof HashMap || params.get("key") instanceof LinkedHashMap){
                    WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                }else {
                    WHERE(column.getColumn() + "=#{key}");
                }
            } else {
                Map key = (Map)params.get("key");
                if (key != null && !key.keySet().isEmpty()){
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassFKColumns()) {
                        if (key.containsKey(column.getProperty())){
                            WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                        }
                    }
                }
            }

            StringBuilder orderBy = new StringBuilder();
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                if (column.getOrderBy() != null) {
                    orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy()).append(",");
                }
            }
            if (orderBy.length() > 0) {
                ORDER_BY(orderBy.substring(0, orderBy.length() - 1));
            }
        }}.toString();
    }

    /**
     * 新增
     *
     * @param params
     * @return
     */
    public String insert(final Map<String, Object> params) {
        return new SQL() {{
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            INSERT_INTO(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
            }
        }}.toString();
    }

    /**
     * 新增非空字段，空字段可以使用表的默认值
     *
     * @param params
     * @return
     */
    public String insertSelective(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            MetaObject metaObject = MapperTemplate.forObject(entity);
            INSERT_INTO(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                if (column.isId() || value != null) {
                    VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }}.toString();
    }

    /**
     * 新增非空字段，空字段可以使用表的默认值
     *
     * @param params
     * @return
     */
    public String insertBatchSelective(final Map<String, Object> params) {
        String insertBatchSql = "";
        List<String> columns = new ArrayList<String>();
        List<String> values = new ArrayList<String>();
        Class<?> entityClass = getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        insertBatchSql += "insert into " + entityTable.getName();
        if (params.containsKey("record") && params.get("record") != null && (params.get("record") instanceof List || params.get("record") instanceof ArrayList)) {
            List list = (List) params.get("record");
            for (int i = 0; i < list.size(); i++) {
                String str = "select ";
                MetaObject metaObject = MapperTemplate.forObject(list.get(i));
                int j = 0;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    j += 1;
                    Object value = metaObject.getValue(column.getProperty());
                    if (i == 0) {
                        columns.add(column.getColumn());
                    }
                    String type = getjdbcType(column.getJavaType().getSimpleName());
                    if (j == entityTable.getEntityClassColumns().size()) {
                        str += "#{record[" + i + "]." + column.getProperty() + "," + type + "}";
                    } else {
                        str += "#{record[" + i + "]." + column.getProperty() + "," + type + "},";
                    }
                }
                str += " from dual";
                values.add(str);
            }
        }
        insertBatchSql += " " + batchSql(columns, ",");
        insertBatchSql += " " + batchSql(values, "union all");
        return insertBatchSql;
    }

    /**
     * lst 拼接批量插入的sql
     *
     * @param list
     * @param split
     * @return
     */
    private String batchSql(List<?> list, String split) {
        String str = "(";
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                str += list.get(i) + " ";
                if (list.size() - i != 1) {
                    str += split + " ";
                }
            }
        }
        str += ")";
        return str;
    }

    /**
     * lst 获取字段的类型
     *
     * @param type
     * @return
     */
    private String getjdbcType(String type) {
        String str = "";
        if (StringUtils.equals(type.toUpperCase(), "DATE")) {
            str = "jdbcType=TIMESTAMP";
        }
        if (StringUtils.equals(type.toUpperCase(), "STRING")) {
            str = "jdbcType=VARCHAR";
        }
        if (StringUtils.equals(type.toUpperCase(), "INTEGER")) {
            str = "jdbcType=INTEGER";
        }
        if (StringUtils.equals(type.toUpperCase(), "DOUBLE")) {
            str = "jdbcType=DOUBLE";
        }
        if (StringUtils.equals(type.toUpperCase(), "FLOAT")) {
            str = "jdbcType=FLOAT";
        }
        return str;
    }


    /**
     * 通过查询条件删除
     *
     * @param params
     * @return
     */
    public String delete(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            MetaObject metaObject = MapperTemplate.forObject(entity);
            DELETE_FROM(entityTable.getName());
            boolean hasValue = false;
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                if (value == null) {
                    continue;
                } else if (column.getJavaType().equals(String.class)) {
                    if (isNotEmpty((String) value)) {
                        WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                        hasValue = true;
                    }
                } else {
                    WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    hasValue = true;
                }
            }
            if (!hasValue) {
                throw new UnsupportedOperationException("delete方法不支持删除全表的操作!");
            }
        }}.toString();
    }

    /**
     * 通过主键删除
     *
     * @param params
     * @return
     */
    public String deleteByPrimaryKey(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            DELETE_FROM(entityTable.getName());
            if (entityTable.getEntityClassPKColumns().size() == 1) {
                EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                notNullKeyProperty(column.getProperty(), entity);
                WHERE(column.getColumn() + "=#{key}");
            } else {
                MetaObject metaObject = MapperTemplate.forObject(entity);
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    notNullKeyProperty(column.getProperty(), value);
                    WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                }
            }
        }}.toString();
    }

    /**
     * 通过主键删除
     *
     * @param params
     * @return
     */
    public String deleteByForeignKey(final Map<String, Object> params) {
        return new SQL() {{
            Map map = (Map)params.get("key");
            for (Object key : map.keySet()) {
                if (map.get(key) == null || StringUtils.isBlank(MapUtils.getString(map,key))){
                    throwNullKeyException("删除条件："+key+"对应的值为空请检查！");
                }
            }
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            DELETE_FROM(entityTable.getName());
            if (entityTable.getEntityClassFKColumns().size() > 0) {
                if (map != null && !map.keySet().isEmpty()){
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassFKColumns()) {
                        if (map.containsKey(column.getProperty())){
                            Object value = metaObject.getValue(column.getProperty());
                            notNullKeyProperty(column.getProperty(), value);
                            WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                        }
                    }
                }
            }
        }}.toString();
    }

    /**
     * 通过主键更新
     *
     * @param params
     * @return
     */
    public String updateByPrimaryKey(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            MetaObject metaObject = MapperTemplate.forObject(entity);
            UPDATE(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                //更新不是ID的字段，因为根据主键查询的...更新后还是一样。
                if (!column.isId()) {
                    SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
            if (entityTable.getEntityClassPKColumns().size() == 1) {
                EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
            } else {
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    notNullKeyProperty(column.getProperty(), value);
                    WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
        }}.toString();
    }

    /**
     * lst 通过主键更新
     * null也会更新
     *
     * @param params
     * @return
     */
    public String updateByPrimaryKeyNull(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            MetaObject metaObject = MapperTemplate.forObject(entity);
            UPDATE(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                //更新不是ID的字段，因为根据主键查询的...更新后还是一样。
                String type = getjdbcType(column.getJavaType().getSimpleName());
                if (!column.isId()) {
                    SET(column.getColumn() + "=#{record." + column.getProperty() + "," + type + "}");
                }
            }
            if (entityTable.getEntityClassPKColumns().size() == 1) {
                EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
            } else {
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    notNullKeyProperty(column.getProperty(), value);
                    WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
        }}.toString();
    }

    /**
     * 通过主键更新非空字段
     *
     * @param params
     * @return
     */
    public String updateByPrimaryKeySelective(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            MetaObject metaObject = MapperTemplate.forObject(entity);
            UPDATE(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                //更新不是ID的字段，因为根据主键查询的...更新后还是一样。
                if (value != null && !column.isId()) {
                    SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
            if (entityTable.getEntityClassPKColumns().size() == 1) {
                EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
            } else {
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                    notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                    WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
        }}.toString();
    }

    public String countByExample(final Map<String, Object> params) {
        return new SQL() {{
            MetaObject example = getExample(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            SELECT("count(*)");
            FROM(entityTable.getName());
            applyWhere(this, example);
        }}.toString();
    }

    public String deleteByExample(final Map<String, Object> params) {
        return new SQL() {{
            MetaObject example = getExample(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            DELETE_FROM(entityTable.getName());
            applyWhere(this, example);
        }}.toString();
    }

    public String selectByExample(final Map<String, Object> params) {
        return new SQL() {{
            MetaObject example = getExample(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            SELECT(EntityHelper.getAllColumns(entityClass));
            FROM(entityTable.getName());
            applyWhere(this, example);
            applyOrderBy(this, example);
        }}.toString();
    }

    public String updateByExampleSelective(final Map<String, Object> params) {
        return new SQL() {{
            Object entity = getEntity(params);
            MetaObject example = getExample(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            MetaObject metaObject = MapperTemplate.forObject(entity);
            UPDATE(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                //更新不是ID的字段，因为根据主键查询的...更新后还是一样。
                if (value != null) {
                    SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
            applyWhere(this, example);
        }}.toString();
    }

    public String updateByExample(final Map<String, Object> params) {
        return new SQL() {{
            MetaObject example = getExample(params);
            Class<?> entityClass = getEntityClass(params);
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
            UPDATE(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                //更新不是ID的字段，因为根据主键查询的...更新后还是一样。
                if (!column.isId()) {
                    SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
            }
            applyWhere(this, example);
        }}.toString();
    }
}
