/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     SourceAttachment.java
 * Modifier: yangxin
 * Modified: 2014-07-02 14:27
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.common.core.ex;

import cn.gtmap.common.utils.HtmlUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-2
 */
public final class Source implements Sourceable, Serializable {
    public static int LINE = 8;
    public static final String CALL_LINK = "http://localhost:8091/?message=%s:%s:%s";
    private static final long serialVersionUID = 1338916470790937007L;
    private String title;
    private String description;
    private String file;
    private List<String> lines = Collections.emptyList();
    private int lineNumber;
    private int columNumber;

    @Override
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public List<String> getLines() {
        return lines;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    @Override
    public int getLineNumber() {
        return lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumNumber() {
        return columNumber;
    }

    public void setColumNumber(int columNumber) {
        this.columNumber = columNumber;
    }

    public List<String> getViewLines() {
        int len = lines.size();
        if (len == 0) {
            return Collections.emptyList();
        }
        int from = lineNumber - LINE > 0 && lineNumber <= len ? lineNumber - LINE : 1;
        int to = lineNumber + LINE < len ? lineNumber + LINE : len;
        List<String> list = Lists.newArrayList();
        for (int i = from; i <= to; i++) {
            String line = lines.get(i - 1);
            String link = String.format(CALL_LINK, file, i, i == lineNumber ? columNumber : 1);
            list.add("<div class=\"line" + (i == lineNumber ? " error" : "") + "\">" + "<span class=\"lineNumber\">" + i + "</span><pre><a href=\"" + link + "\" onclick=\"return cl(this);\">&nbsp;" + HtmlUtils.escape(line) + "</a></pre></div>");
        }
        return list;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
