/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AppException.java
 * Modifier: yangxin
 * Modified: 2014-06-10 16:28
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.common.core.ex;


import cn.gtmap.common.utils.Codecs;
import cn.gtmap.common.utils.ExUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-10-11
 */
public class AppException extends RuntimeException implements ErrorCode {
    private static final long serialVersionUID = 5052516665736233092L;
    private String id = Codecs.uuid(8);
    private int code = SERVER_EX;
    private String message;
    private Object args[];

    public AppException() {
        super();
    }

    public AppException(String message) {
        super();
        this.message = message;
    }

    public AppException(Throwable cause) {
        super(cause);
        code = ExUtils.parseCode(cause);
    }

    public AppException(String message, Throwable cause) {
        this(cause);
        this.message = message;
    }

    public AppException(int code, Object... args) {
        super();
        this.code = code;
        this.args = args;
    }

    public AppException(String message, int code, Object... args) {
        this(code, args);
        this.message = message;
    }

    public AppException(Throwable cause, int code, Object... args) {
        super(cause);
        this.code = code;
        this.args = args;
    }

    public AppException(String message, Throwable cause, int code, Object... args) {
        super(cause);
        this.message = message;
        this.code = code;
        this.args = args;
    }

    public String getId() {
        return id;
    }

    public int getCode() {
        return code;
    }

    public Object[] getArgs() {
        return args;
    }

    public String getStack() {
        return ExUtils.buildStackTrace(this);
    }

    public String getMessage() {
        return ExUtils.buildMessage(code, args, message, getCause());
    }

    public String getSimpleMessage() {
        return ExUtils.buildMessage(code, args, message, null);
    }

    @Override
    public String toString() {
        return getMessage();
    }
}
