/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.collect.Sets;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import java.util.HashSet;

class ReadOnlyCommands {
    public static final ProtocolKeyword[] READ_ONLY_COMMANDS;

    ReadOnlyCommands() {
    }

    static {
        HashSet set = Sets.newHashSet();
        for (CommandName commandNames : CommandName.values()) {
            set.add(CommandType.valueOf(commandNames.name()));
        }
        READ_ONLY_COMMANDS = set.toArray(new ProtocolKeyword[set.size()]);
    }

    static enum CommandName {
        ASKING,
        BITCOUNT,
        BITPOS,
        CLIENT,
        COMMAND,
        DUMP,
        ECHO,
        EXISTS,
        GEODIST,
        GEOPOS,
        GEORADIUS,
        GEORADIUSBYMEMBER,
        GET,
        GETBIT,
        GETRANGE,
        HEXISTS,
        HGET,
        HGETALL,
        HKEYS,
        HLEN,
        HMGET,
        HSCAN,
        HSTRLEN,
        HVALS,
        INFO,
        KEYS,
        LINDEX,
        LLEN,
        LRANGE,
        MGET,
        MULTI,
        PFCOUNT,
        PTTL,
        RANDOMKEY,
        READWRITE,
        SCAN,
        SCARD,
        SCRIPT,
        SDIFF,
        SINTER,
        SISMEMBER,
        SMEMBERS,
        SRANDMEMBER,
        SSCAN,
        STRLEN,
        SUNION,
        TIME,
        TTL,
        TYPE,
        WAIT,
        ZCARD,
        ZCOUNT,
        ZLEXCOUNT,
        ZRANGE,
        ZRANGEBYLEX,
        ZRANGEBYSCORE,
        ZRANK,
        ZREVRANGE,
        ZREVRANGEBYSCORE,
        ZREVRANK,
        ZSCAN,
        ZSCORE;

    }
}

