/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.ConnectionPoint;
import com.lambdaworks.redis.EpollProvider;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class RedisURI
implements Serializable,
ConnectionPoint {
    public static final String URI_SCHEME_REDIS_SENTINEL = "redis-sentinel";
    public static final String URI_SCHEME_REDIS = "redis";
    public static final String URI_SCHEME_REDIS_SECURE = "rediss";
    public static final String URI_SCHEME_REDIS_SECURE_ALT = "redis+ssl";
    public static final String URI_SCHEME_REDIS_TLS_ALT = "redis+tls";
    public static final String URI_SCHEME_REDIS_SOCKET = "redis-socket";
    public static final String URI_SCHEME_REDIS_SOCKET_ALT = "redis+socket";
    public static final String PARAMETER_NAME_TIMEOUT = "timeout";
    public static final String PARAMETER_NAME_DATABASE = "database";
    public static final String PARAMETER_NAME_DATABASE_ALT = "db";
    public static final String PARAMETER_NAME_SENTINEL_MASTER_ID = "sentinelMasterId";
    public static final Map<String, TimeUnit> TIME_UNIT_MAP;
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_REDIS_PORT = 6379;
    public static final long DEFAULT_TIMEOUT = 60L;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT;
    private String host;
    private String socket;
    private String sentinelMasterId;
    private int port;
    private int database;
    private char[] password;
    private boolean ssl = false;
    private boolean verifyPeer = true;
    private boolean startTls = false;
    private long timeout = 60L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private final List<RedisURI> sentinels = new ArrayList<RedisURI>();

    public RedisURI() {
    }

    public RedisURI(String host, int port, long timeout, TimeUnit unit) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.unit = unit;
    }

    public static RedisURI create(String uri) {
        return RedisURI.create(URI.create(uri));
    }

    public static RedisURI create(URI uri) {
        String pathSuffix;
        Builder builder = uri.getScheme().equals(URI_SCHEME_REDIS_SENTINEL) ? RedisURI.configureSentinel(uri) : RedisURI.configureStandalone(uri);
        String userInfo = uri.getUserInfo();
        if (LettuceStrings.isEmpty(userInfo) && LettuceStrings.isNotEmpty(uri.getAuthority()) && uri.getAuthority().indexOf(64) > 0) {
            userInfo = uri.getAuthority().substring(0, uri.getAuthority().indexOf(64));
        }
        if (LettuceStrings.isNotEmpty(userInfo)) {
            String password = userInfo;
            if (password.startsWith(":")) {
                password = password.substring(1);
            } else {
                int index = password.indexOf(58);
                if (index > 0) {
                    password = password.substring(index + 1);
                }
            }
            if (password != null && !password.equals("")) {
                builder.withPassword(password);
            }
        }
        if (LettuceStrings.isNotEmpty(uri.getPath()) && builder.socket == null && LettuceStrings.isNotEmpty(pathSuffix = uri.getPath().substring(1))) {
            builder.withDatabase(Integer.parseInt(pathSuffix));
        }
        if (LettuceStrings.isNotEmpty(uri.getQuery())) {
            StringTokenizer st = new StringTokenizer(uri.getQuery(), "&;");
            while (st.hasMoreTokens()) {
                String queryParam = st.nextToken();
                String forStartWith = queryParam.toLowerCase();
                if (forStartWith.startsWith("timeout=")) {
                    RedisURI.parseTimeout(builder, queryParam.toLowerCase());
                }
                if (forStartWith.startsWith("database=") || queryParam.startsWith("db=")) {
                    RedisURI.parseDatabase(builder, queryParam);
                }
                if (!forStartWith.startsWith(PARAMETER_NAME_SENTINEL_MASTER_ID.toLowerCase() + "=")) continue;
                RedisURI.parseSentinelMasterId(builder, queryParam);
            }
        }
        if (uri.getScheme().equals(URI_SCHEME_REDIS_SENTINEL)) {
            Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(builder.sentinelMasterId), (Object)"URI must contain the sentinelMasterId");
        }
        return builder.build();
    }

    private static void parseTimeout(Builder builder, String queryParam) {
        int numbersEnd;
        int index = queryParam.indexOf(61);
        if (index < 0) {
            return;
        }
        String timeoutString = queryParam.substring(index + 1);
        for (numbersEnd = 0; numbersEnd < timeoutString.length() && Character.isDigit(timeoutString.charAt(numbersEnd)); ++numbersEnd) {
        }
        if (numbersEnd == 0) {
            if (timeoutString.startsWith("-")) {
                builder.withTimeout(0L, TimeUnit.MILLISECONDS);
            }
        } else {
            String timeoutValueString = timeoutString.substring(0, numbersEnd);
            long timeoutValue = Long.parseLong(timeoutValueString);
            builder.withTimeout(timeoutValue, TimeUnit.MILLISECONDS);
            String suffix = timeoutString.substring(numbersEnd);
            TimeUnit timeoutUnit = TIME_UNIT_MAP.get(suffix);
            if (timeoutUnit == null) {
                timeoutUnit = TimeUnit.MILLISECONDS;
            }
            builder.withTimeout(timeoutValue, timeoutUnit);
        }
    }

    private static void parseDatabase(Builder builder, String queryParam) {
        int numbersEnd;
        int index = queryParam.indexOf(61);
        if (index < 0) {
            return;
        }
        String databaseString = queryParam.substring(index + 1);
        for (numbersEnd = 0; numbersEnd < databaseString.length() && Character.isDigit(databaseString.charAt(numbersEnd)); ++numbersEnd) {
        }
        if (numbersEnd != 0) {
            String databaseValueString = databaseString.substring(0, numbersEnd);
            int value = Integer.parseInt(databaseValueString);
            builder.withDatabase(value);
        }
    }

    private static void parseSentinelMasterId(Builder builder, String queryParam) {
        int index = queryParam.indexOf(61);
        if (index < 0) {
            return;
        }
        String masterIdString = queryParam.substring(index + 1);
        if (LettuceStrings.isNotEmpty(masterIdString)) {
            builder.withSentinelMasterId(masterIdString);
        }
    }

    private static Builder configureStandalone(URI uri) {
        ImmutableSet allowedSchemes = ImmutableSet.of((Object)URI_SCHEME_REDIS, (Object)URI_SCHEME_REDIS_SECURE, (Object)URI_SCHEME_REDIS_SOCKET, (Object)URI_SCHEME_REDIS_SOCKET_ALT, (Object)URI_SCHEME_REDIS_SECURE_ALT, (Object)URI_SCHEME_REDIS_TLS_ALT, (Object[])new String[0]);
        if (!allowedSchemes.contains(uri.getScheme())) {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " not supported");
        }
        Builder builder = URI_SCHEME_REDIS_SOCKET.equals(uri.getScheme()) || URI_SCHEME_REDIS_SOCKET_ALT.equals(uri.getScheme()) ? Builder.socket(uri.getPath()) : (uri.getPort() > 0 ? Builder.redis(uri.getHost(), uri.getPort()) : Builder.redis(uri.getHost()));
        if (URI_SCHEME_REDIS_SECURE.equals(uri.getScheme()) || URI_SCHEME_REDIS_SECURE_ALT.equals(uri.getScheme())) {
            builder.withSsl(true);
        }
        if (URI_SCHEME_REDIS_TLS_ALT.equals(uri.getScheme())) {
            builder.withSsl(true);
            builder.withStartTls(true);
        }
        return builder;
    }

    private static Builder configureSentinel(URI uri) {
        String masterId = uri.getFragment();
        Builder builder = null;
        if (LettuceStrings.isNotEmpty(uri.getHost())) {
            builder = uri.getPort() != -1 ? Builder.sentinel(uri.getHost(), uri.getPort(), masterId) : Builder.sentinel(uri.getHost(), masterId);
        }
        if (builder == null && LettuceStrings.isNotEmpty(uri.getAuthority())) {
            String[] hosts;
            String authority = uri.getAuthority();
            if (authority.indexOf(64) > -1) {
                authority = authority.substring(authority.indexOf(64) + 1);
            }
            for (String host : hosts = authority.split("\\,")) {
                HostAndPort hostAndPort = HostAndPort.fromString((String)host);
                if (builder == null) {
                    if (hostAndPort.hasPort()) {
                        builder = Builder.sentinel(hostAndPort.getHostText(), hostAndPort.getPort(), masterId);
                        continue;
                    }
                    builder = Builder.sentinel(hostAndPort.getHostText(), masterId);
                    continue;
                }
                if (hostAndPort.hasPort()) {
                    builder.withSentinel(hostAndPort.getHostText(), hostAndPort.getPort());
                    continue;
                }
                builder.withSentinel(hostAndPort.getHostText());
            }
        }
        Preconditions.checkArgument((builder != null ? 1 : 0) != 0, (Object)"Invalid URI, cannot get host part");
        return builder;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    public void setSocket(String socket) {
        this.socket = socket;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public List<RedisURI> getSentinels() {
        return this.sentinels;
    }

    public URI toURI() {
        String scheme = this.getScheme();
        String authority = this.getAuthority(scheme);
        String queryString = this.getQueryString();
        String uri = scheme + "://" + authority;
        if (!queryString.isEmpty()) {
            uri = uri + "?" + queryString;
        }
        return URI.create(uri);
    }

    private String getAuthority(final String scheme) {
        String authority = null;
        if (this.host != null) {
            authority = this.urlEncode(this.host) + this.getPortPart(this.port, scheme);
        }
        if (this.sentinels.size() != 0) {
            List strings = Lists.transform(this.sentinels, (Function)new Function<RedisURI, String>(){

                @Nullable
                public String apply(RedisURI input) {
                    return RedisURI.this.urlEncode(input.getHost()) + RedisURI.this.getPortPart(input.getPort(), scheme);
                }
            });
            authority = Joiner.on((char)',').join((Iterable)strings);
        }
        if (this.socket != null) {
            authority = this.urlEncode(this.socket);
        }
        if (this.password != null && this.password.length != 0) {
            authority = this.urlEncode(new String(this.password)) + "@" + authority;
        }
        return authority;
    }

    private String getQueryString() {
        ArrayList queryPairs = Lists.newArrayList();
        if (this.database != 0) {
            queryPairs.add("database=" + this.database);
        }
        if (this.sentinelMasterId != null) {
            queryPairs.add("sentinelMasterId=" + this.urlEncode(this.sentinelMasterId));
        }
        if (this.timeout != 0L && this.unit != null && this.timeout != 60L && !this.unit.equals((Object)DEFAULT_TIMEOUT_UNIT)) {
            queryPairs.add("timeout=" + this.timeout + this.toQueryParamUnit(this.unit));
        }
        return Joiner.on((char)'&').join((Iterable)queryPairs);
    }

    private String getPortPart(int port, String scheme) {
        if (URI_SCHEME_REDIS_SENTINEL.equals(scheme) && port == 26379) {
            return "";
        }
        if (URI_SCHEME_REDIS.equals(scheme) && port == 6379) {
            return "";
        }
        return ":" + port;
    }

    private String getScheme() {
        String scheme = URI_SCHEME_REDIS;
        if (this.isSsl()) {
            scheme = this.isStartTls() ? URI_SCHEME_REDIS_TLS_ALT : URI_SCHEME_REDIS_SECURE;
        }
        if (this.socket != null) {
            scheme = URI_SCHEME_REDIS_SOCKET;
        }
        if (this.host == null && !this.sentinels.isEmpty()) {
            scheme = URI_SCHEME_REDIS_SENTINEL;
        }
        return scheme;
    }

    private String toQueryParamUnit(TimeUnit unit) {
        for (Map.Entry<String, TimeUnit> entry : TIME_UNIT_MAP.entrySet()) {
            if (!entry.getValue().equals((Object)unit)) continue;
            return entry.getKey();
        }
        return "";
    }

    private String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, LettuceCharsets.UTF8.name()).replaceAll("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public SocketAddress getResolvedAddress() {
        if (this.getSocket() != null) {
            return EpollProvider.newSocketAddress(this.getSocket());
        }
        InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
        return socketAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        if (this.host != null) {
            sb.append("host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
        }
        if (this.socket != null) {
            sb.append("socket='").append(this.socket).append('\'');
        }
        if (this.sentinelMasterId != null) {
            sb.append("sentinels=").append(this.getSentinels());
            sb.append(", sentinelMasterId=").append(this.sentinelMasterId);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisURI)) {
            return false;
        }
        RedisURI redisURI = (RedisURI)o;
        if (this.port != redisURI.port) {
            return false;
        }
        if (this.database != redisURI.database) {
            return false;
        }
        if (this.host != null ? !this.host.equals(redisURI.host) : redisURI.host != null) {
            return false;
        }
        if (this.socket != null ? !this.socket.equals(redisURI.socket) : redisURI.socket != null) {
            return false;
        }
        if (this.sentinelMasterId != null ? !this.sentinelMasterId.equals(redisURI.sentinelMasterId) : redisURI.sentinelMasterId != null) {
            return false;
        }
        return !(this.sentinels == null ? redisURI.sentinels != null : !this.sentinels.equals(redisURI.sentinels));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.socket != null ? this.socket.hashCode() : 0);
        result = 31 * result + (this.sentinelMasterId != null ? this.sentinelMasterId.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.database;
        result = 31 * result + (this.sentinels != null ? this.sentinels.hashCode() : 0);
        return result;
    }

    static /* synthetic */ char[] access$402(RedisURI x0, char[] x1) {
        x0.password = x1;
        return x1;
    }

    static {
        HashMap<String, TimeUnit> unitMap = new HashMap<String, TimeUnit>();
        unitMap.put("ns", TimeUnit.NANOSECONDS);
        unitMap.put("us", TimeUnit.MICROSECONDS);
        unitMap.put("ms", TimeUnit.MILLISECONDS);
        unitMap.put("s", TimeUnit.SECONDS);
        unitMap.put("m", TimeUnit.MINUTES);
        unitMap.put("h", TimeUnit.HOURS);
        unitMap.put("d", TimeUnit.DAYS);
        TIME_UNIT_MAP = Collections.unmodifiableMap(unitMap);
        DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    }

    public static class Builder {
        private String host;
        private String socket;
        private String sentinelMasterId;
        private int port;
        private int database;
        private char[] password;
        private boolean ssl = false;
        private boolean verifyPeer = true;
        private boolean startTls = false;
        private long timeout = 60L;
        private TimeUnit unit = TimeUnit.SECONDS;
        private final List<HostAndPort> sentinels = new ArrayList<HostAndPort>();

        public static Builder socket(String socket) {
            Preconditions.checkNotNull((Object)socket, (Object)"Socket must not be null");
            Builder builder = new Builder();
            builder.socket = socket;
            return builder;
        }

        public static Builder redis(String host) {
            return Builder.redis(host, 6379);
        }

        public static Builder redis(String host, int port) {
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            Builder builder = new Builder();
            builder.host = host;
            builder.port = port;
            return builder;
        }

        public static Builder sentinel(String host) {
            return Builder.sentinel(host, 26379, null);
        }

        public static Builder sentinel(String host, int port) {
            return Builder.sentinel(host, port, null);
        }

        public static Builder sentinel(String host, String masterId) {
            return Builder.sentinel(host, 26379, masterId);
        }

        public static Builder sentinel(String host, int port, String masterId) {
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            Builder builder = new Builder();
            builder.sentinelMasterId = masterId;
            builder.withSentinel(host, port);
            return builder;
        }

        public Builder withSentinel(String host) {
            return this.withSentinel(host, 26379);
        }

        public Builder withSentinel(String host, int port) {
            Preconditions.checkState((this.host == null ? 1 : 0) != 0, (Object)"Cannot use with Redis mode.");
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            this.sentinels.add(HostAndPort.fromParts((String)host, (int)port));
            return this;
        }

        public Builder withPort(int port) {
            Preconditions.checkState((this.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.port = port;
            return this;
        }

        public Builder withSsl(boolean ssl) {
            Preconditions.checkState((this.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.ssl = ssl;
            return this;
        }

        public Builder withStartTls(boolean startTls) {
            Preconditions.checkState((this.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.startTls = startTls;
            return this;
        }

        public Builder withVerifyPeer(boolean verifyPeer) {
            Preconditions.checkState((this.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.verifyPeer = verifyPeer;
            return this;
        }

        public Builder withDatabase(int database) {
            Preconditions.checkArgument((database >= 0 && database <= 15 ? 1 : 0) != 0, (Object)("Invalid database number: " + database));
            this.database = database;
            return this;
        }

        public Builder withPassword(String password) {
            Preconditions.checkNotNull((Object)password, (Object)"Password must not be null");
            this.password = password.toCharArray();
            return this;
        }

        public Builder withTimeout(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"TimeUnit must not be null");
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"Timeout must be greater or equal 0");
            this.timeout = timeout;
            this.unit = unit;
            return this;
        }

        public Builder withSentinelMasterId(String sentinelMasterId) {
            Preconditions.checkNotNull((Object)sentinelMasterId, (Object)"Sentinel master id must not ne null");
            this.sentinelMasterId = sentinelMasterId;
            return this;
        }

        public RedisURI build() {
            RedisURI redisURI = new RedisURI();
            redisURI.setHost(this.host);
            redisURI.setPort(this.port);
            RedisURI.access$402(redisURI, this.password);
            redisURI.setDatabase(this.database);
            redisURI.setSentinelMasterId(this.sentinelMasterId);
            for (HostAndPort sentinel : this.sentinels) {
                redisURI.getSentinels().add(new RedisURI(sentinel.getHostText(), sentinel.getPort(), this.timeout, this.unit));
            }
            redisURI.setSocket(this.socket);
            redisURI.setSsl(this.ssl);
            redisURI.setStartTls(this.startTls);
            redisURI.setVerifyPeer(this.verifyPeer);
            redisURI.setTimeout(this.timeout);
            redisURI.setUnit(this.unit);
            return redisURI;
        }
    }
}

